/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.gui;

import java.util.Objects;
import java.util.function.Consumer;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.gui.PictureFrameScreenHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;

public class PictureFrameScreen
extends AbstractContainerScreen<PictureFrameScreenHandler>
implements ContainerListener {
    private static final ResourceLocation TEXTURE = Camerapture.id("textures/gui/edit_picture_frame.png");
    private int frameWidth = 0;
    private int frameHeight = 0;
    private boolean glowing = false;
    private boolean fixed = false;
    private Button upButton;
    private Button leftButton;
    private Button rightButton;
    private Button downButton;
    private SmallCheckboxWidget glowingCheckbox;
    private SmallCheckboxWidget fixedCheckbox;

    public PictureFrameScreen(PictureFrameScreenHandler screenHandler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)screenHandler, inventory, title);
        screenHandler.addSlotListener(this);
        this.imageWidth = 158;
        this.imageHeight = 52;
    }

    protected void init() {
        super.init();
        this.upButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> {
            this.sendButtonPressPacket(PictureFrameScreen.hasShiftDown() ? 0 : 1);
            this.frameHeight += PictureFrameScreen.hasShiftDown() ? -1 : 1;
        }).bounds(this.width / 2 - this.imageWidth / 2, this.height / 2 - this.imageHeight / 2 - 20 - 4, this.imageWidth, 20).build());
        this.rightButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> {
            this.sendButtonPressPacket(PictureFrameScreen.hasShiftDown() ? 2 : 3);
            this.frameWidth += PictureFrameScreen.hasShiftDown() ? -1 : 1;
        }).bounds(this.width / 2 + this.imageWidth / 2 + 4, this.height / 2 - this.imageHeight / 2, 20, this.imageHeight).build());
        this.downButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> {
            this.sendButtonPressPacket(PictureFrameScreen.hasShiftDown() ? 4 : 5);
            this.frameHeight += PictureFrameScreen.hasShiftDown() ? -1 : 1;
        }).bounds(this.width / 2 - this.imageWidth / 2, this.height / 2 + this.imageHeight / 2 + 4, this.imageWidth, 20).build());
        this.leftButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> {
            this.sendButtonPressPacket(PictureFrameScreen.hasShiftDown() ? 6 : 7);
            this.frameWidth += PictureFrameScreen.hasShiftDown() ? -1 : 1;
        }).bounds(this.width / 2 - this.imageWidth / 2 - 20 - 4, this.height / 2 - this.imageHeight / 2, 20, this.imageHeight).build());
        this.glowingCheckbox = (SmallCheckboxWidget)this.addRenderableWidget((GuiEventListener)new SmallCheckboxWidget((Component)Component.translatable((String)"text.camerapture.edit_picture_frame.glowing"), glowing -> {
            this.sendButtonPressPacket(8);
            this.glowing = glowing;
        }, this.width / 2 - this.imageWidth / 2 + 7, this.height / 2 - this.imageHeight / 2 + 34, false, this.glowing));
        this.fixedCheckbox = (SmallCheckboxWidget)this.addRenderableWidget((GuiEventListener)new SmallCheckboxWidget((Component)Component.translatable((String)"text.camerapture.edit_picture_frame.fixed"), fixed -> {
            this.sendButtonPressPacket(9);
            this.fixed = fixed;
        }, this.width / 2 + this.imageWidth / 2 - 7 - 11, this.height / 2 - this.imageHeight / 2 + 34, true, this.fixed));
        this.updateButtons();
    }

    private void sendButtonPressPacket(int id) {
        if (this.minecraft == null || this.minecraft.gameMode == null) {
            return;
        }
        this.minecraft.gameMode.handleInventoryButtonClick(((PictureFrameScreenHandler)this.menu).containerId, id);
    }

    public void slotChanged(AbstractContainerMenu handler, int slotId, ItemStack stack) {
    }

    public void dataChanged(AbstractContainerMenu handler, int property, int value) {
        switch (property) {
            case 0: {
                this.frameWidth = value;
                break;
            }
            case 1: {
                this.frameHeight = value;
                break;
            }
            case 2: {
                this.glowing = value == 1;
                break;
            }
            case 3: {
                this.fixed = value == 1;
            }
        }
        this.updateButtons();
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        context.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        context.drawCenteredString(this.font, (Component)Component.translatable((String)"text.camerapture.edit_picture_frame.size", (Object[])new Object[]{this.frameWidth, this.frameHeight}), this.imageWidth / 2, 7, 0xFFFFFF);
        MutableComponent mutableComponent = Component.translatable((String)"text.camerapture.edit_picture_frame.shrink_hint");
        int n = this.imageWidth / 2;
        Objects.requireNonNull(this.font);
        context.drawCenteredString(this.font, (Component)mutableComponent, n, 7 + 9 + 2, 0xA0A0A0);
    }

    private void updateButtons() {
        if (PictureFrameScreen.hasShiftDown()) {
            this.upButton.setMessage(Component.nullToEmpty((String)"\u2193"));
            this.leftButton.setMessage(Component.nullToEmpty((String)"\u2192"));
            this.rightButton.setMessage(Component.nullToEmpty((String)"\u2190"));
            this.downButton.setMessage(Component.nullToEmpty((String)"\u2191"));
            this.upButton.active = this.frameHeight > 1;
            this.leftButton.active = this.frameWidth > 1;
            this.rightButton.active = this.frameWidth > 1;
            this.downButton.active = this.frameHeight > 1;
        } else {
            this.upButton.setMessage(Component.nullToEmpty((String)"\u2191"));
            this.leftButton.setMessage(Component.nullToEmpty((String)"\u2190"));
            this.rightButton.setMessage(Component.nullToEmpty((String)"\u2192"));
            this.downButton.setMessage(Component.nullToEmpty((String)"\u2193"));
            this.upButton.active = this.frameHeight < 16;
            this.leftButton.active = this.frameWidth < 16;
            this.rightButton.active = this.frameWidth < 16;
            this.downButton.active = this.frameHeight < 16;
        }
        this.glowingCheckbox.checked = this.glowing;
        this.fixedCheckbox.checked = this.fixed;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.updateButtons();
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        this.updateButtons();
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static class SmallCheckboxWidget
    extends AbstractButton {
        private final boolean leftText;
        private boolean checked;
        private final Consumer<Boolean> onChange;

        public SmallCheckboxWidget(Component text, Consumer<Boolean> onChange, int x, int y, boolean leftText, boolean checked) {
            super(x, y, 11, 11, text);
            this.onChange = onChange;
            this.leftText = leftText;
            this.checked = checked;
        }

        public void onPress() {
            this.checked = !this.checked;
            this.onChange.accept(this.checked);
        }

        protected void updateWidgetNarration(NarrationElementOutput builder) {
            builder.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
            if (this.active) {
                if (this.isFocused()) {
                    builder.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.focused"));
                } else {
                    builder.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.hovered"));
                }
            }
        }

        protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
            Minecraft minecraftClient = Minecraft.getInstance();
            Font textRenderer = minecraftClient.font;
            int textX = this.getX() + (this.leftText ? -4 - textRenderer.width((FormattedText)this.getMessage()) : 15);
            context.drawString(textRenderer, this.getMessage(), textX, this.getY() + 2, 0xE0E0E0);
            context.blit(TEXTURE, this.getX(), this.getY(), this.isHoveredOrFocused() ? 11.0f : 0.0f, 52.0f, 11, 11, 256, 256);
            if (this.checked) {
                context.blit(TEXTURE, this.getX(), this.getY(), 22.0f, 52.0f, 11, 11, 256, 256);
            }
        }
    }
}

