/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.entity;

import me.chrr.camerapture.Camerapture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class ResizableDecorationEntity
extends Entity {
    public static final double THICKNESS = 0.0625;
    private static final EntityDataAccessor<Integer> FRAME_WIDTH = SynchedEntityData.defineId(ResizableDecorationEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FRAME_HEIGHT = SynchedEntityData.defineId(ResizableDecorationEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private Direction facing = Direction.SOUTH;
    private BlockPos attachmentPos;
    private int obstructionCheckCounter = 0;

    public ResizableDecorationEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(FRAME_WIDTH, (Object)1);
        builder.define(FRAME_HEIGHT, (Object)1);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (data.equals(FRAME_WIDTH) || data.equals(FRAME_HEIGHT)) {
            this.updateBoundingBox();
        }
    }

    public void resetObstructionCheckCounter() {
        this.obstructionCheckCounter = 0;
    }

    public void tick() {
        if (this.level() instanceof ServerLevel && Camerapture.CONFIG_MANAGER.getConfig().server.checkFramePosition && this.obstructionCheckCounter++ == 100) {
            this.obstructionCheckCounter = 0;
            if (!this.canStayAttached() && !this.isRemoved()) {
                this.discard();
                this.onBreak(null);
            }
        }
    }

    public BlockPos getAttachmentPos() {
        return this.attachmentPos;
    }

    public void setAttachmentPos(BlockPos attachmentPos) {
        this.attachmentPos = attachmentPos;
        this.updateBoundingBox();
    }

    public Direction getNearestViewDirection() {
        return this.facing;
    }

    public void setFacing(Direction facing) {
        this.facing = facing;
        this.setYRot(this.facing.get2DDataValue() * 90);
        this.yRotO = this.getYRot();
        this.updateBoundingBox();
    }

    public int getFrameWidth() {
        return (Integer)this.getEntityData().get(FRAME_WIDTH);
    }

    public void setFrameWidth(int width) {
        this.getEntityData().set(FRAME_WIDTH, (Object)width);
        this.updateBoundingBox();
    }

    public int getFrameHeight() {
        return (Integer)this.getEntityData().get(FRAME_HEIGHT);
    }

    public void setFrameHeight(int height) {
        this.getEntityData().set(FRAME_HEIGHT, (Object)height);
        this.updateBoundingBox();
    }

    protected void updateBoundingBox() {
        if (this.facing == null) {
            return;
        }
        Vec3 center = this.attachmentPos.getCenter();
        center = center.subtract(new Vec3((double)this.facing.getStepX(), 0.0, (double)this.facing.getStepZ()).scale(0.46875));
        this.setPosRaw(center.x, center.y, center.z);
        Direction parallel = this.facing.getCounterClockWise();
        if (this.facing.getAxis() == Direction.Axis.Z) {
            Vec3 p1 = center.subtract((double)parallel.getStepX() * 0.5, 0.5, 0.03125);
            Vec3 p2 = p1.add((double)(parallel.getStepX() * this.getFrameWidth()), (double)this.getFrameHeight(), 0.0625);
            this.setBoundingBox(new AABB(p1, p2));
        } else {
            Vec3 p1 = center.subtract(0.03125, 0.5, (double)parallel.getStepZ() * 0.5);
            Vec3 p2 = p1.add(0.0625, (double)this.getFrameHeight(), (double)(parallel.getStepZ() * this.getFrameWidth()));
            this.setBoundingBox(new AABB(p1, p2));
        }
        this.resetObstructionCheckCounter();
    }

    public Direction getDirection() {
        return this.getNearestViewDirection();
    }

    public boolean isPickable() {
        return true;
    }

    public boolean canStayAttached() {
        if (!Camerapture.CONFIG_MANAGER.getConfig().server.checkFramePosition) {
            return true;
        }
        if (!this.level().noCollision((Entity)this)) {
            return false;
        }
        BlockPos blockPos = this.attachmentPos.relative(this.facing.getOpposite());
        Direction direction = this.facing.getCounterClockWise();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = 0; x < this.getFrameWidth(); ++x) {
            for (int y = 0; y < this.getFrameHeight(); ++y) {
                mutable.set((Vec3i)blockPos).move(direction, x).move(Direction.UP, y);
                BlockState blockState = this.level().getBlockState((BlockPos)mutable);
                if (blockState.isSolid() || DiodeBlock.isDiode((BlockState)blockState)) continue;
                return false;
            }
        }
        return this.level().getEntities((Entity)this, this.getBoundingBox(), entity -> entity instanceof HangingEntity || entity instanceof ResizableDecorationEntity).isEmpty();
    }

    public boolean skipAttackInteraction(Entity attacker) {
        if (attacker instanceof Player) {
            Player playerEntity = (Player)attacker;
            return !this.level().mayInteract(playerEntity, this.blockPosition()) || this.hurt(this.damageSources().playerAttack(playerEntity), 0.0f);
        }
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.isRemoved() && !this.level().isClientSide) {
            this.kill();
            this.markHurt();
            this.onBreak(source.getEntity());
        }
        return true;
    }

    public void move(MoverType movementType, Vec3 movement) {
        if (this.level() instanceof ServerLevel && !this.isRemoved() && movement.lengthSqr() > 0.0) {
            this.kill();
            this.onBreak(null);
        }
    }

    public void push(double deltaX, double deltaY, double deltaZ) {
        if (this.level() instanceof ServerLevel && !this.isRemoved() && deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ > 0.0) {
            this.kill();
            this.onBreak(null);
        }
    }

    public void setPos(double x, double y, double z) {
        this.attachmentPos = BlockPos.containing((double)x, (double)y, (double)z);
        this.updateBoundingBox();
        this.hasImpulse = true;
    }

    public float rotate(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                this.setFacing(this.getNearestViewDirection().getOpposite());
                break;
            }
            case COUNTERCLOCKWISE_90: {
                this.setFacing(this.getNearestViewDirection().getCounterClockWise());
                break;
            }
            case CLOCKWISE_90: {
                this.setFacing(this.getNearestViewDirection().getClockWise());
            }
        }
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> this.getYRot() + 180.0f;
            case Rotation.COUNTERCLOCKWISE_90 -> this.getYRot() + 90.0f;
            case Rotation.CLOCKWISE_90 -> this.getYRot() + 270.0f;
            default -> this.getYRot();
        };
    }

    public ItemEntity spawnAtLocation(ItemStack stack, float yOffset) {
        Vec3 center = this.getBoundingBox().getCenter();
        ItemEntity itemEntity = new ItemEntity(this.level(), center.x + (double)((float)this.getNearestViewDirection().getStepX() * 0.15f), center.y + (double)yOffset, center.z + (double)((float)this.getNearestViewDirection().getStepZ() * 0.15f), stack);
        itemEntity.setDefaultPickUpDelay();
        this.level().addFreshEntity((Entity)itemEntity);
        return itemEntity;
    }

    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putInt("TileX", this.attachmentPos.getX());
        nbt.putInt("TileY", this.attachmentPos.getY());
        nbt.putInt("TileZ", this.attachmentPos.getZ());
        nbt.putByte("Facing", (byte)this.getNearestViewDirection().get3DDataValue());
        nbt.putInt("Width", this.getFrameWidth());
        nbt.putInt("Height", this.getFrameHeight());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        BlockPos blockPos = new BlockPos(nbt.getInt("TileX"), nbt.getInt("TileY"), nbt.getInt("TileZ"));
        if (!blockPos.closerThan((Vec3i)this.blockPosition(), 16.0)) {
            Camerapture.LOGGER.error("hanging entity at invalid position: {}", (Object)blockPos);
        } else {
            this.attachmentPos = blockPos;
        }
        this.setFacing(Direction.from3DDataValue((int)nbt.getByte("Facing")));
        this.setFrameWidth(nbt.getInt("Width"));
        this.setFrameHeight(nbt.getInt("Height"));
        this.updateBoundingBox();
    }

    public float mirror(Mirror mirror) {
        return this.rotate(mirror.getRotation(this.getNearestViewDirection()));
    }

    public void thunderHit(ServerLevel world, LightningBolt lightning) {
    }

    public abstract void onPlace();

    public abstract void onBreak(@Nullable Entity var1);
}

