/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.entity;

import java.util.Optional;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.entity.ResizableDecorationEntity;
import me.chrr.camerapture.gui.PictureFrameScreenHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PictureFrameEntity
extends ResizableDecorationEntity
implements MenuProvider {
    public static final ResourceLocation ID = Camerapture.id("picture_frame");
    public static final ResourceKey<EntityType<?>> KEY = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ID);
    private static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.defineId(PictureFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Boolean> GLOWING = SynchedEntityData.defineId(PictureFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FIXED = SynchedEntityData.defineId(PictureFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ROTATION = SynchedEntityData.defineId(PictureFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public PictureFrameEntity(EntityType<? extends PictureFrameEntity> entityType, Level world) {
        super(entityType, world);
    }

    public PictureFrameEntity(Level world, BlockPos pos, Direction facing) {
        super(Camerapture.PICTURE_FRAME, world);
        this.setAttachmentPos(pos);
        this.setFacing(facing);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ITEM_STACK, (Object)ItemStack.EMPTY);
        builder.define(GLOWING, (Object)false);
        builder.define(FIXED, (Object)false);
        builder.define(ROTATION, (Object)0);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        boolean canRotate = Camerapture.CONFIG_MANAGER.getConfig().server.canRotatePictures;
        if (player.isShiftKeyDown()) {
            player.openMenu((MenuProvider)this);
            return InteractionResult.SUCCESS;
        }
        if (canRotate && !this.isFixed()) {
            if (!player.level().isClientSide) {
                this.setRotation(this.getRotation() + 1);
                this.playSound(SoundEvents.ITEM_FRAME_ROTATE_ITEM, 1.0f, 1.0f);
                this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, (Entity)player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void onBreak(@Nullable Entity entity) {
        this.playSound(SoundEvents.ITEM_FRAME_BREAK, 1.0f, 1.0f);
        this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, entity);
        ItemStack itemStack = this.getItemStack();
        if (!itemStack.isEmpty()) {
            itemStack.setEntityRepresentation(null);
            this.spawnAtLocation(itemStack);
        }
    }

    @Override
    public void onPlace() {
        this.playSound(SoundEvents.ITEM_FRAME_PLACE, 1.0f, 1.0f);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.getEntityData().get(ITEM_STACK);
    }

    public void setItemStack(ItemStack itemStack) {
        this.getEntityData().set(ITEM_STACK, (Object)itemStack);
    }

    public boolean isPictureGlowing() {
        return (Boolean)this.getEntityData().get(GLOWING);
    }

    public void setPictureGlowing(boolean glowing) {
        this.getEntityData().set(GLOWING, (Object)glowing);
    }

    public boolean isFixed() {
        return (Boolean)this.getEntityData().get(FIXED);
    }

    public void setFixed(boolean fixed) {
        this.getEntityData().set(FIXED, (Object)fixed);
        this.resetObstructionCheckCounter();
    }

    public int getRotation() {
        return (Integer)this.getEntityData().get(ROTATION);
    }

    public void setRotation(int rotation) {
        this.getEntityData().set(ROTATION, (Object)(rotation % 4));
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        ItemStack itemStack;
        super.onSyncedDataUpdated(data);
        if (data.equals(ITEM_STACK) && !(itemStack = this.getItemStack()).isEmpty()) {
            itemStack.setEntityRepresentation((Entity)this);
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d = 16.0;
        return distance < (d *= 4.0 * PictureFrameEntity.getViewScale()) * d;
    }

    @Override
    public void move(MoverType movementType, Vec3 movement) {
        if (!this.isFixed()) {
            super.move(movementType, movement);
        }
    }

    @Override
    public void push(double deltaX, double deltaY, double deltaZ) {
        if (!this.isFixed()) {
            super.push(deltaX, deltaY, deltaZ);
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.isFixed() && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !source.isCreativePlayer()) {
            return false;
        }
        return super.hurt(source, amount);
    }

    @Override
    public boolean canStayAttached() {
        return this.isFixed() || super.canStayAttached();
    }

    public void resize(ResizeDirection direction, boolean shrink) {
        boolean success;
        switch (direction.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
            case 1: {
                boolean bl = this.tryAddHeight(shrink ? -1 : 1);
                break;
            }
            case 2: 
            case 3: {
                boolean bl = success = this.tryAddWidth(shrink ? -1 : 1);
            }
        }
        if (success) {
            int i = shrink ? 1 : -1;
            switch (direction.ordinal()) {
                case 1: {
                    this.setAttachmentPos(this.getAttachmentPos().relative(Direction.UP, i));
                    break;
                }
                case 2: {
                    this.setAttachmentPos(this.getAttachmentPos().relative(this.getNearestViewDirection().getCounterClockWise(), i));
                }
            }
        }
        this.resetObstructionCheckCounter();
    }

    private boolean tryAddWidth(int n) {
        int width = this.getFrameWidth();
        if (width >= 1 - n && width <= 16 - n) {
            this.setFrameWidth(width + n);
            return true;
        }
        return false;
    }

    private boolean tryAddHeight(int n) {
        int height = this.getFrameHeight();
        if (height >= 1 - n && height <= 16 - n) {
            this.setFrameHeight(height + n);
            return true;
        }
        return false;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entityTrackerEntry) {
        return new ClientboundAddEntityPacket((Entity)this, this.getNearestViewDirection().get3DDataValue(), this.blockPosition());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.setFacing(Direction.from3DDataValue((int)packet.getData()));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        ItemStack itemStack = this.getItemStack();
        if (!itemStack.isEmpty()) {
            nbt.put("Item", itemStack.save((HolderLookup.Provider)this.registryAccess()));
        }
        nbt.putBoolean("PictureGlowing", this.isPictureGlowing());
        nbt.putBoolean("Fixed", this.isFixed());
        nbt.putInt("PictureRotation", this.getRotation());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        CompoundTag nbtCompound = nbt.getCompound("Item");
        if (nbtCompound != null && !nbtCompound.isEmpty()) {
            Optional itemStack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)nbtCompound);
            if (itemStack.isEmpty()) {
                Camerapture.LOGGER.warn("unable to load item from: {}", (Object)nbtCompound);
            } else {
                this.setItemStack((ItemStack)itemStack.get());
            }
        }
        this.setPictureGlowing(nbt.getBoolean("PictureGlowing"));
        this.setFixed(nbt.getBoolean("Fixed"));
        this.setRotation(nbt.getInt("PictureRotation"));
    }

    public ItemStack getPickResult() {
        return this.getItemStack().copy();
    }

    public boolean hasCustomName() {
        return this.getItemStack().get(DataComponents.CUSTOM_NAME) != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.hasCustomName() ? this.getItemStack().getHoverName() : null;
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new PictureFrameScreenHandler(syncId, this, new ContainerData(){

            public int get(int id) {
                return switch (id) {
                    case 0 -> PictureFrameEntity.this.getFrameWidth();
                    case 1 -> PictureFrameEntity.this.getFrameHeight();
                    case 2 -> {
                        if (PictureFrameEntity.this.isPictureGlowing()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 3 -> {
                        if (PictureFrameEntity.this.isFixed()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void set(int id, int value) {
            }

            public int getCount() {
                return 4;
            }
        });
    }

    public static enum ResizeDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

