/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.register.helpers.list_providers;

import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.lopyluna.dndecor.register.helpers.list_providers.MaterialTypeProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class MetalTypeBlockList<T extends Block>
implements Iterable<BlockEntry<T>> {
    private final BlockEntry<?>[] values = new BlockEntry[MaterialTypeProvider.metalTypes.size()];

    public MetalTypeBlockList(Function<NonNullSupplier<MaterialTypeProvider.MetalType>, BlockEntry<T>> filler) {
        for (NonNullSupplier<MaterialTypeProvider.MetalType> type : MaterialTypeProvider.metalTypes) {
            int index = MaterialTypeProvider.metalTypes.indexOf(type);
            if (index < 0) continue;
            this.values[index] = filler.apply(type);
        }
    }

    public BlockEntry<T> get(MaterialTypeProvider.MetalType metal) {
        NonNullSupplier type = () -> metal;
        int index = MaterialTypeProvider.metalTypes.indexOf(type);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public BlockEntry<T> get(NonNullSupplier<MaterialTypeProvider.MetalType> type) {
        int index = MaterialTypeProvider.metalTypes.indexOf(type);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public boolean contains(Block block) {
        for (BlockEntry<?> entry : this.values) {
            if (!entry.is((Object)block)) continue;
            return true;
        }
        return false;
    }

    public BlockEntry<T>[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    @NotNull
    public Iterator<BlockEntry<T>> iterator() {
        return new Iterator<BlockEntry<T>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < MetalTypeBlockList.this.values.length;
            }

            @Override
            public BlockEntry<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return MetalTypeBlockList.this.values[this.index++];
            }
        };
    }
}

