/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects;

import com.mcwfurnitures.kikoz.MacawsFurnitures;
import com.mcwfurnitures.kikoz.storage.CouchEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Couch
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<CouchShape> SHAPE = EnumProperty.create((String)"shape", CouchShape.class);
    private static final VoxelShape W_SINGLE = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)14.0, (double)3.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)13.0, (double)0.0, (double)14.0, (double)15.0, (double)2.0, (double)16.0), Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)3.0), Block.box((double)1.0, (double)7.0, (double)12.0, (double)15.0, (double)17.0, (double)16.0), Block.box((double)0.0, (double)7.0, (double)0.0, (double)4.0, (double)11.0, (double)15.0), Block.box((double)12.0, (double)7.0, (double)0.0, (double)16.0, (double)11.0, (double)15.0), Block.box((double)1.0, (double)2.0, (double)0.0, (double)15.0, (double)7.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)2.0, (double)3.0)});
    private static final VoxelShape W_MIDDLE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)17.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0));
    private static final VoxelShape W_LEFT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)7.0, (double)12.0, (double)16.0, (double)17.0, (double)16.0), Block.box((double)0.0, (double)7.0, (double)0.0, (double)4.0, (double)11.0, (double)16.0), Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)1.0, (double)2.0, (double)2.0, (double)3.0)});
    private static final VoxelShape W_RIGHT = Shapes.or((VoxelShape)Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)14.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)3.0), Block.box((double)0.0, (double)7.0, (double)12.0, (double)15.0, (double)17.0, (double)16.0), Block.box((double)12.0, (double)7.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0)});
    private static final VoxelShape W_CORNER = Shapes.or((VoxelShape)Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)17.0, (double)16.0), Block.box((double)12.0, (double)7.0, (double)0.0, (double)16.0, (double)17.0, (double)12.0), Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0)});
    private static final VoxelShape N_SINGLE = MacawsFurnitures.calculateShapes(Direction.EAST, W_SINGLE);
    private static final VoxelShape N_MIDDLE = MacawsFurnitures.calculateShapes(Direction.EAST, W_MIDDLE);
    private static final VoxelShape N_LEFT = MacawsFurnitures.calculateShapes(Direction.EAST, W_LEFT);
    private static final VoxelShape N_RIGHT = MacawsFurnitures.calculateShapes(Direction.EAST, W_RIGHT);
    private static final VoxelShape N_CORNER = MacawsFurnitures.calculateShapes(Direction.EAST, W_CORNER);
    private static final VoxelShape S_SINGLE = MacawsFurnitures.calculateShapes(Direction.WEST, W_SINGLE);
    private static final VoxelShape S_MIDDLE = MacawsFurnitures.calculateShapes(Direction.WEST, W_MIDDLE);
    private static final VoxelShape S_LEFT = MacawsFurnitures.calculateShapes(Direction.WEST, W_LEFT);
    private static final VoxelShape S_RIGHT = MacawsFurnitures.calculateShapes(Direction.WEST, W_RIGHT);
    private static final VoxelShape S_CORNER = MacawsFurnitures.calculateShapes(Direction.WEST, W_CORNER);
    private static final VoxelShape E_SINGLE = MacawsFurnitures.calculateShapes(Direction.SOUTH, W_SINGLE);
    private static final VoxelShape E_MIDDLE = MacawsFurnitures.calculateShapes(Direction.SOUTH, W_MIDDLE);
    private static final VoxelShape E_LEFT = MacawsFurnitures.calculateShapes(Direction.SOUTH, W_LEFT);
    private static final VoxelShape E_RIGHT = MacawsFurnitures.calculateShapes(Direction.SOUTH, W_RIGHT);
    private static final VoxelShape E_CORNER = MacawsFurnitures.calculateShapes(Direction.SOUTH, W_CORNER);

    public Couch(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(SHAPE, (Comparable)((Object)CouchShape.SINGLE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SHAPE, FACING});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return CouchEntity.create(level, pos, 0.7, player);
    }

    private BlockState StairState(BlockState state, LevelAccessor access, BlockPos pos) {
        boolean north = access.getBlockState(pos.north()).getBlock() == this;
        boolean east = access.getBlockState(pos.east()).getBlock() == this;
        boolean south = access.getBlockState(pos.south()).getBlock() == this;
        boolean west = access.getBlockState(pos.west()).getBlock() == this;
        Direction facingDirection = (Direction)state.getValue((Property)FACING);
        CouchShape connection = this.getCouchShape(facingDirection, north, east, south, west);
        return (BlockState)((BlockState)state.setValue(SHAPE, (Comparable)((Object)connection))).setValue((Property)FACING, (Comparable)facingDirection);
    }

    private CouchShape getCouchShape(Direction facing, boolean north, boolean east, boolean south, boolean west) {
        switch (facing) {
            case NORTH: {
                if (!north && !south) {
                    return CouchShape.SINGLE;
                }
                if (north && south) {
                    return CouchShape.MIDDLE;
                }
                if (!north && south && !east && !west) {
                    return CouchShape.LEFT;
                }
                if (north && !south && !east && !west) {
                    return CouchShape.RIGHT;
                }
                if (north && !south && east) {
                    return CouchShape.LEFT_CORNER;
                }
                if (north || !south || !east) break;
                return CouchShape.RIGHT_CORNER;
            }
            case EAST: {
                if (!east && !west) {
                    return CouchShape.SINGLE;
                }
                if (east && west) {
                    return CouchShape.MIDDLE;
                }
                if (!east && west && !north && !south) {
                    return CouchShape.LEFT;
                }
                if (east && !west && !north && !south) {
                    return CouchShape.RIGHT;
                }
                if (east && !west && south) {
                    return CouchShape.LEFT_CORNER;
                }
                if (east || !west || !south) break;
                return CouchShape.RIGHT_CORNER;
            }
            case SOUTH: {
                if (!north && !south) {
                    return CouchShape.SINGLE;
                }
                if (north && south) {
                    return CouchShape.MIDDLE;
                }
                if (north && !south && !east && !west) {
                    return CouchShape.LEFT;
                }
                if (!north && south && !east && !west) {
                    return CouchShape.RIGHT;
                }
                if (north && !south && west) {
                    return CouchShape.RIGHT_CORNER;
                }
                if (north || !south || !west) break;
                return CouchShape.LEFT_CORNER;
            }
            case WEST: {
                if (!east && !west) {
                    return CouchShape.SINGLE;
                }
                if (east && west) {
                    return CouchShape.MIDDLE;
                }
                if (east && !west && !north && !south) {
                    return CouchShape.LEFT;
                }
                if (!east && west && !north && !south) {
                    return CouchShape.RIGHT;
                }
                if (east && !west && north) {
                    return CouchShape.RIGHT_CORNER;
                }
                if (east || !west || !north) break;
                return CouchShape.LEFT_CORNER;
            }
        }
        return CouchShape.SINGLE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        CouchShape shape = (CouchShape)((Object)state.getValue(SHAPE));
        return switch (facing) {
            case Direction.NORTH -> {
                switch (shape.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield N_SINGLE;
                    }
                    case 2: {
                        yield N_MIDDLE;
                    }
                    case 1: {
                        yield N_LEFT;
                    }
                    case 3: {
                        yield N_RIGHT;
                    }
                    case 4: {
                        yield N_CORNER;
                    }
                    case 5: 
                }
                yield E_CORNER;
            }
            case Direction.EAST -> {
                switch (shape.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield E_SINGLE;
                    }
                    case 2: {
                        yield E_MIDDLE;
                    }
                    case 1: {
                        yield E_LEFT;
                    }
                    case 3: {
                        yield E_RIGHT;
                    }
                    case 4: {
                        yield E_CORNER;
                    }
                    case 5: 
                }
                yield S_CORNER;
            }
            case Direction.SOUTH -> {
                switch (shape.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield S_SINGLE;
                    }
                    case 2: {
                        yield S_MIDDLE;
                    }
                    case 1: {
                        yield S_LEFT;
                    }
                    case 3: {
                        yield S_RIGHT;
                    }
                    case 4: {
                        yield S_CORNER;
                    }
                    case 5: 
                }
                yield W_CORNER;
            }
            case Direction.WEST -> {
                switch (shape.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield W_SINGLE;
                    }
                    case 2: {
                        yield W_MIDDLE;
                    }
                    case 1: {
                        yield W_LEFT;
                    }
                    case 3: {
                        yield W_RIGHT;
                    }
                    case 4: {
                        yield W_CORNER;
                    }
                    case 5: 
                }
                yield N_CORNER;
            }
            default -> N_SINGLE;
        };
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.is(state.getBlock())) {
            level.setBlock(pos, this.StairState(state, (LevelAccessor)level, pos), 2);
        }
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return this.StairState(state, access, pos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext contx) {
        BlockPos pos = contx.getClickedPos().below();
        Level world = contx.getLevel();
        Direction facingDirection = contx.getHorizontalDirection().getClockWise();
        return (BlockState)this.StairState(super.getStateForPlacement(contx), (LevelAccessor)contx.getLevel(), contx.getClickedPos()).setValue((Property)FACING, (Comparable)facingDirection);
    }

    public static enum CouchShape implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        MIDDLE("middle"),
        RIGHT("right"),
        LEFT_CORNER("left_corner"),
        RIGHT_CORNER("right_corner");

        private final String name;

        private CouchShape(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

