/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.block.Blocks;

public class LeafParticle
extends TextureSheetParticle {
    private final float rotSpeed;

    private LeafParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z, motionX, motionY, motionZ);
        float f;
        this.rCol = f = this.random.nextFloat() * 1.0f;
        this.gCol = f;
        this.bCol = f;
        this.setSize(0.05f, 0.05f);
        this.quadSize = 0.25f;
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.lifetime = (int)(50.0 / (Math.random() * 1.0));
        this.rotSpeed = ((float)Math.random() - 0.5f) * 0.1f;
        this.roll = (float)Math.random() * 0.7853982f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        this.hasPhysics = true;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.oRoll = this.roll;
            this.roll += (float)Math.PI * this.rotSpeed;
            if (this.onGround || this.level.getBlockState(new BlockPos((int)this.x, (int)this.y, (int)this.z).above(0)).is(Blocks.WATER)) {
                this.roll = this.oRoll;
                this.age = (int)((float)this.age * 1.015f);
                this.yd = 0.0;
                this.xd *= (double)0.95f;
                this.zd *= (double)0.95f;
            }
            if (this.onGround && this.level.getBlockState(new BlockPos((int)this.x, (int)this.y, (int)this.z).below(1)).isAir()) {
                this.remove();
            }
            this.move(this.xd, this.yd, this.zd);
            this.xd += (double)(this.random.nextFloat() / 500.0f);
            this.yd += -5.0E-4;
            this.zd += (double)(this.random.nextFloat() / 500.0f);
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LeafParticle leafParticle = new LeafParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            leafParticle.setColor(1.0f, 1.0f, 1.0f);
            leafParticle.pickSprite(this.spriteSet);
            return leafParticle;
        }
    }
}

