/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.recipes;

import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class DistillationRecipe
extends StandardProcessingRecipe<RecipeInput> {
    public DistillationRecipe(ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)TFMGRecipeTypes.DISTILLATION, params);
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    protected boolean canRequireHeat() {
        return true;
    }

    public SizedFluidIngredient getInputFluid() {
        return (SizedFluidIngredient)this.getFluidIngredients().get(0);
    }

    public int getMaxFluidOutputCount() {
        return 6;
    }

    public int getMaxInputCount() {
        return 0;
    }

    public int getMaxFluidInputCount() {
        return 1;
    }

    public int getMaxOutputCount() {
        return 0;
    }

    public FluidStack getFirstFluidResult() {
        return (FluidStack)this.fluidResults.get(0);
    }

    public int getOutputCount(DistillationRecipe recipe) {
        return recipe.fluidResults.toArray().length;
    }

    public boolean matches(FluidTank inv, int outputs) {
        int neededOutputs = this.fluidIngredients.toArray().length;
        if (outputs != neededOutputs) {
            return false;
        }
        if (inv.getFluidInTank(0).getAmount() == 0) {
            return false;
        }
        return ((SizedFluidIngredient)this.fluidIngredients.get(0)).test(inv.getFluidInTank(0));
    }

    public boolean matches(RecipeInput pContainer, Level pLevel) {
        return false;
    }
}

