/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.vat.industrial_mixer;

import com.drmangotea.tfmg.content.machinery.vat.industrial_mixer.IndustrialMixerBlockEntity;
import com.drmangotea.tfmg.registry.TFMGPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class IndustrialMixerRenderer
extends KineticBlockEntityRenderer<IndustrialMixerBlockEntity> {
    public IndustrialMixerRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(IndustrialMixerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        BlockState blockState = be.getBlockState();
        int height = be.vatHeight;
        if (be.mixerMode == IndustrialMixerBlockEntity.MixerMode.NONE) {
            return;
        }
        if (!Minecraft.getInstance().isPaused()) {
            be.angle += be.visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
            be.angle %= 360.0f;
        }
        for (int i = 0; i < height; ++i) {
            PartialModel model;
            PartialModel partialModel = i == height - 1 ? (be.vatSize > 1 ? TFMGPartialModels.MIXER : TFMGPartialModels.SMALL_MIXER) : (model = TFMGPartialModels.MIXER_SHAFT);
            if (be.mixerMode == IndustrialMixerBlockEntity.MixerMode.CENTRIFUGE) {
                if (be.vatPos == null) {
                    return;
                }
                model = this.getCentrifugeModel(i + 1, height, be);
            }
            float posX = be.vatSize == 2 ? (float)(be.vatPos.getX() - be.getBlockPos().getX()) + 0.5f : 0.0f;
            float posZ = be.vatSize == 2 ? (float)(be.vatPos.getZ() - be.getBlockPos().getZ()) + 0.5f : 0.0f;
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)model, (BlockState)blockState).light(LevelRenderer.getLightColor((BlockAndTintGetter)be.getLevel(), (BlockPos)be.getBlockPos().below())).center()).translate(posX, (float)(-i - 1), posZ)).rotateYDegrees(be.angle)).uncenter()).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
        }
    }

    public PartialModel getCentrifugeModel(int i, int height, IndustrialMixerBlockEntity be) {
        if (be.vatSize == 1) {
            if (height == 1) {
                return TFMGPartialModels.SMALL_CENTRIFUGE_ALONE;
            }
            if (i == 1) {
                return TFMGPartialModels.SMALL_CENTRIFUGE_TOP;
            }
            if (i == height) {
                return TFMGPartialModels.SMALL_CENTRIFUGE_BOTTOM;
            }
            return TFMGPartialModels.SMALL_CENTRIFUGE_MIDDLE;
        }
        if (height == 1) {
            return TFMGPartialModels.LARGE_CENTRIFUGE_ALONE;
        }
        if (i == 1) {
            return TFMGPartialModels.LARGE_CENTRIFUGE_TOP;
        }
        if (i == height) {
            return TFMGPartialModels.LARGE_CENTRIFUGE_BOTTOM;
        }
        return TFMGPartialModels.LARGE_CENTRIFUGE_MIDDLE;
    }

    protected SuperByteBuffer getRotatedModel(IndustrialMixerBlockEntity be, BlockState state) {
        return CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)state, (Direction)Direction.UP);
    }
}

