/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.flarestack;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.machinery.misc.flarestack.FlarestackBlock;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.Create;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FlarestackBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected IFluidHandler fluidCapability;
    public FluidTank tankInventory = this.createInventory();
    public boolean spawnsSmoke = false;
    public int smokeTimer = 0;

    public FlarestackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = this.tankInventory;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.FLARESTACK.get(), (be, context) -> be.fluidCapability);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(this, 2500, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().is(TFMGTags.TFMGFluidTags.FLAMMABLE.tag) || stack.getFluid().is(TFMGTags.TFMGFluidTags.FUEL.tag);
            }
        };
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        this.sendData();
        this.setChanged();
    }

    public void tick() {
        super.tick();
        if (this.smokeTimer != 0) {
            this.spawnsSmoke = true;
            --this.smokeTimer;
        } else {
            this.spawnsSmoke = false;
        }
        if (this.spawnsSmoke) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)FlarestackBlock.LIT, (Comparable)Boolean.valueOf(true)), 2);
            FlarestackBlockEntity.makeParticles(this.level, this.getBlockPos());
        } else {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)FlarestackBlock.LIT, (Comparable)Boolean.valueOf(false)), 2);
        }
        if (this.tankInventory.getFluidAmount() > 0) {
            this.smokeTimer = 100;
            this.spawnsSmoke = true;
            if (this.tankInventory.getFluidAmount() > 1000) {
                this.tankInventory.drain(100, IFluidHandler.FluidAction.EXECUTE);
            } else {
                this.tankInventory.drain(30, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public static void makeParticles(Level level, BlockPos pos) {
        Random random = Create.RANDOM;
        int shouldSpawnSmoke = random.nextInt(7);
        if (shouldSpawnSmoke == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, (double)((float)pos.getX() + random.nextFloat(1.0f)), (double)(pos.getY() + 1), (double)((float)pos.getZ() + random.nextFloat(1.0f)), 0.0, 0.08, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + random.nextFloat(1.0f)), (double)(pos.getY() + 1), (double)((float)pos.getZ() + random.nextFloat(1.0f)), Create.RANDOM.nextDouble(0.28) - 0.14, 0.14, Create.RANDOM.nextDouble(0.28) - 0.14);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + random.nextFloat(1.0f)), (double)(pos.getY() + 1), (double)((float)pos.getZ() + random.nextFloat(1.0f)), Create.RANDOM.nextDouble(0.28) - 0.14, 0.14, Create.RANDOM.nextDouble(0.28) - 0.14);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + random.nextFloat(1.0f)), (double)(pos.getY() + 1), (double)((float)pos.getZ() + random.nextFloat(1.0f)), Create.RANDOM.nextDouble(0.28) - 0.14, 0.14, Create.RANDOM.nextDouble(0.28) - 0.14);
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.tankInventory.readFromNBT(registries, compound.getCompound("TankContent"));
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }
}

