/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.firebox;

import com.drmangotea.tfmg.content.machinery.misc.firebox.FireboxBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class FireboxBlock
extends Block
implements IWrenchable,
IBE<FireboxBlockEntity> {
    public static final EnumProperty<BlazeBurnerBlock.HeatLevel> HEAT_LEVEL = BlazeBurnerBlock.HEAT_LEVEL;

    public FireboxBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.NONE));
    }

    public static boolean isFirebox(BlockState state) {
        return state.getBlock() instanceof FireboxBlock;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.getBlock() == state.getBlock()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, FireboxBlockEntity::updateConnectivity);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HEAT_LEVEL});
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 0;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && (state.getBlock() != newState.getBlock() || !newState.hasBlockEntity())) {
            BlockEntity be = world.getBlockEntity(pos);
            if (!(be instanceof FireboxBlockEntity)) {
                return;
            }
            FireboxBlockEntity tankBE = (FireboxBlockEntity)be;
            world.removeBlockEntity(pos);
            ConnectivityHandler.splitMulti((BlockEntity)tankBE);
        }
    }

    public Class<FireboxBlockEntity> getBlockEntityClass() {
        return FireboxBlockEntity.class;
    }

    public BlockEntityType<? extends FireboxBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.FIREBOX.get();
    }
}

