/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.exhaust;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.machinery.misc.exhaust.ExhaustBlock;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.simibubi.create.Create;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class ExhaustBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected IFluidHandler fluidCapability;
    public FluidTank tankInventory = this.createInventory();
    public boolean spawnsSmoke = false;
    public int smokeTimer = 0;

    public ExhaustBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = this.tankInventory;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.EXHAUST.get(), (be, context) -> be.fluidCapability);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(this, 1000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().isSame((Fluid)TFMGFluids.CARBON_DIOXIDE.getSource());
            }
        };
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        this.sendData();
        this.setChanged();
    }

    public void tick() {
        super.tick();
        Direction direction = (Direction)this.getBlockState().getValue((Property)ExhaustBlock.FACING);
        if (this.smokeTimer != 0) {
            this.spawnsSmoke = true;
            --this.smokeTimer;
        } else {
            this.spawnsSmoke = false;
        }
        if (direction == Direction.UP && this.spawnsSmoke) {
            ExhaustBlockEntity.makeParticles(this.level, this.getBlockPos(), 0);
        }
        if (direction == Direction.DOWN && this.spawnsSmoke) {
            ExhaustBlockEntity.makeParticles(this.level, this.getBlockPos(), 1);
        }
        if (direction == Direction.NORTH && this.spawnsSmoke) {
            ExhaustBlockEntity.makeParticles(this.level, this.getBlockPos(), 2);
        }
        if (direction == Direction.SOUTH && this.spawnsSmoke) {
            ExhaustBlockEntity.makeParticles(this.level, this.getBlockPos(), 3);
        }
        if (direction == Direction.EAST && this.spawnsSmoke) {
            ExhaustBlockEntity.makeParticles(this.level, this.getBlockPos(), 4);
        }
        if (direction == Direction.WEST && this.spawnsSmoke) {
            ExhaustBlockEntity.makeParticles(this.level, this.getBlockPos(), 5);
        }
        if (this.tankInventory.getFluidAmount() > 0) {
            this.smokeTimer = 100;
            this.spawnsSmoke = true;
        }
        if (this.tankInventory.getSpace() > 700) {
            this.tankInventory.drain(100, IFluidHandler.FluidAction.EXECUTE);
        } else {
            this.tankInventory.drain(10, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.tankInventory.readFromNBT(registries, compound.getCompound("TankContent"));
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
        compound.putBoolean("Active", this.smokeTimer > 0);
    }

    public static void makeParticles(Level level, BlockPos pos, int particleRotation) {
        Random random = Create.RANDOM;
        int shouldSpawnSmoke = random.nextInt(7);
        if (shouldSpawnSmoke == 0) {
            if (particleRotation == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, (double)((float)pos.getX() + random.nextFloat(1.0f)), (double)(pos.getY() + 1), (double)((float)pos.getZ() + random.nextFloat(1.0f)), 0.0, 0.08, 0.0);
            }
            if (particleRotation == 1) {
                level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, (double)((float)pos.getX() + random.nextFloat(1.0f)), (double)pos.getY(), (double)((float)pos.getZ() + random.nextFloat(1.0f)), 0.0, 0.08, 0.0);
            }
            if (particleRotation == 2) {
                level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, (double)((float)pos.getX() + random.nextFloat(1.0f)), (double)((float)pos.getY() + random.nextFloat(1.0f)), (double)pos.getZ(), 0.0, 0.08, 0.0);
            }
            if (particleRotation == 3) {
                level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, (double)((float)pos.getX() + random.nextFloat(1.0f)), (double)((float)pos.getY() + random.nextFloat(1.0f)), (double)(pos.getZ() + 1), 0.0, 0.08, 0.0);
            }
            if (particleRotation == 4) {
                level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, (double)(pos.getX() + 1), (double)((float)pos.getY() + random.nextFloat(1.0f)), (double)((float)pos.getZ() + random.nextFloat(1.0f)), 0.0, 0.08, 0.0);
            }
            if (particleRotation == 5) {
                level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, (double)pos.getX(), (double)((float)pos.getY() + random.nextFloat(1.0f)), (double)((float)pos.getZ() + random.nextFloat(1.0f)), 0.0, 0.08, 0.0);
            }
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }
}

