/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.air_intake;

import com.drmangotea.tfmg.content.machinery.misc.air_intake.AirIntakeBlockEntity;
import com.drmangotea.tfmg.registry.TFMGPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class AirIntakeRenderer
extends KineticBlockEntityRenderer<AirIntakeBlockEntity> {
    public AirIntakeRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(AirIntakeBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        Direction direction = (Direction)be.getBlockState().getValue((Property)BlockStateProperties.FACING);
        VertexConsumer vb = buffer.getBuffer(RenderType.cutoutMipped());
        SuperByteBuffer frame = be.hasShaft ? CachedBuffers.partialFacing((PartialModel)TFMGPartialModels.AIR_INTAKE_FRAME, (BlockState)be.getBlockState(), (Direction)direction).light(light) : CachedBuffers.partialFacing((PartialModel)TFMGPartialModels.AIR_INTAKE_FRAME_CLOSED, (BlockState)be.getBlockState(), (Direction)direction).light(light);
        if (direction == Direction.NORTH) {
            frame.translateZ(0.001f);
        }
        if (direction == Direction.SOUTH) {
            frame.translateZ(-0.001f);
        }
        if (direction == Direction.WEST) {
            frame.translateX(0.001f);
        }
        if (direction == Direction.EAST) {
            frame.translateX(-0.001f);
        }
        if (direction == Direction.UP) {
            frame.translateY(-0.001f);
        }
        if (direction == Direction.DOWN) {
            frame.translateY(0.001f);
        }
        frame.renderInto(ms, vb);
        if (be.diameter == 2) {
            SuperByteBuffer chassisMedium = CachedBuffers.partialFacing((PartialModel)TFMGPartialModels.AIR_INTAKE_MEDIUM, (BlockState)be.getBlockState(), (Direction)direction).light(light);
            if (direction == Direction.UP) {
                chassisMedium.translateZ(1.0f);
            }
            if (direction.getAxis().isVertical()) {
                chassisMedium.translateX(1.0f);
            }
            chassisMedium.renderInto(ms, vb);
        }
        if (be.diameter == 3) {
            SuperByteBuffer chassisLarge = CachedBuffers.partialFacing((PartialModel)TFMGPartialModels.AIR_INTAKE_LARGE, (BlockState)be.getBlockState(), (Direction)direction).light(light);
            if (direction.getAxis().isHorizontal()) {
                chassisLarge.translateY(1.0f);
                if (direction == Direction.NORTH) {
                    chassisLarge.translateX(1.0f);
                }
                if (direction == Direction.SOUTH) {
                    chassisLarge.translateX(-1.0f);
                }
                if (direction == Direction.EAST) {
                    chassisLarge.translateZ(1.0f);
                }
                if (direction == Direction.WEST) {
                    chassisLarge.translateZ(-1.0f);
                }
            } else {
                chassisLarge.translateZ(1.0f);
                chassisLarge.translateX(1.0f);
            }
            chassisLarge.renderInto(ms, vb);
        }
        int lightBehind = LevelRenderer.getLightColor((BlockAndTintGetter)be.getLevel(), (BlockPos)be.getBlockPos().relative(direction.getOpposite()));
        int lightInFront = LevelRenderer.getLightColor((BlockAndTintGetter)be.getLevel(), (BlockPos)be.getBlockPos().relative(direction));
        SuperByteBuffer shaftHalf = CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)be.getBlockState(), (Direction)direction.getOpposite());
        SuperByteBuffer fanInner = CachedBuffers.partialFacing((PartialModel)AllPartialModels.ENCASED_FAN_INNER, (BlockState)be.getBlockState(), (Direction)direction.getOpposite());
        if (be.diameter == 2) {
            fanInner = CachedBuffers.partialFacing((PartialModel)TFMGPartialModels.AIR_INTAKE_FAN_MEDIUM, (BlockState)be.getBlockState(), (Direction)direction.getOpposite());
        }
        if (be.diameter == 3) {
            fanInner = CachedBuffers.partialFacing((PartialModel)TFMGPartialModels.AIR_INTAKE_FAN_LARGE, (BlockState)be.getBlockState(), (Direction)direction.getOpposite());
        }
        if (direction.getAxis().isHorizontal()) {
            float x = 0.0f;
            float z = 0.0f;
            if (direction == Direction.NORTH) {
                x = 1.0f;
            }
            if (direction == Direction.SOUTH) {
                x = -1.0f;
            }
            if (direction == Direction.WEST) {
                z = -1.0f;
            }
            if (direction == Direction.EAST) {
                z = 1.0f;
            }
            if (be.diameter == 3) {
                fanInner.translate(x, 1.0f, z);
            }
            if (be.diameter == 2) {
                fanInner.translate((double)(x / 2.0f), 0.5, (double)(z / 2.0f));
            }
        } else {
            if (be.diameter == 2) {
                fanInner.translate(0.5, 0.0, 0.5);
            }
            if (be.diameter == 3) {
                fanInner.translate(1.0f, 0.0f, 1.0f);
            }
        }
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        float speed = be.maxShaftSpeed * 2.0f;
        if (speed > 0.0f) {
            speed = Mth.clamp((float)speed, (float)80.0f, (float)1280.0f);
        }
        if (speed < 0.0f) {
            speed = Mth.clamp((float)speed, (float)-1280.0f, (float)-80.0f);
        }
        float angle = time * speed * 3.0f / 10.0f % 360.0f;
        angle = angle / 180.0f * (float)Math.PI;
        AirIntakeRenderer.standardKineticRotationTransform((SuperByteBuffer)shaftHalf, (KineticBlockEntity)be, (int)lightBehind).renderInto(ms, vb);
        if (!be.isUsedByController) {
            AirIntakeRenderer.kineticRotationTransform((SuperByteBuffer)fanInner, (KineticBlockEntity)be, (Direction.Axis)direction.getAxis(), (float)angle, (int)lightInFront).renderInto(ms, vb);
        }
    }
}

