/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.metallurgy.blast_stove;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.lang.TFMGLang;
import com.drmangotea.tfmg.base.lang.TFMGTexts;
import com.drmangotea.tfmg.recipes.HotBlastRecipe;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BlastStoveBlockEntity
extends FluidTankBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer.Fluid {
    private static final int MAX_SIZE = 2;
    protected IFluidHandler primaryCapability;
    protected IFluidHandler secondaryCapability;
    public FluidTank primaryOutputInventory;
    public FluidTank secondaryOutputInventory;
    public FluidTank primaryInputInventory;
    public FluidTank secondaryInputInventory;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    public boolean updateConnectivity;
    private static final Object HotBlastRecipesKey = new Object();
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    public int timer = 0;

    public BlastStoveBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        this.primaryOutputInventory = TFMGUtils.createTank(8000, true, false, this::onFluidStackChanged);
        this.secondaryOutputInventory = TFMGUtils.createTank(8000, true, false, this::onFluidStackChanged);
        this.primaryInputInventory = TFMGUtils.createTank(8000, false, this::onFluidStackChanged);
        this.secondaryInputInventory = TFMGUtils.createTank(8000, false, this::onFluidStackChanged);
        this.primaryCapability = new CombinedTankWrapper(new IFluidHandler[]{this.primaryOutputInventory, this.secondaryInputInventory});
        this.secondaryCapability = new CombinedTankWrapper(new IFluidHandler[]{this.primaryInputInventory, this.secondaryOutputInventory});
        this.updateConnectivity = false;
        this.height = 1;
        this.width = 1;
        this.refreshCapability();
    }

    public void updateBoilerState() {
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (!this.isController()) {
            return;
        }
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.offset(xOffset, yOffset, zOffset));
                    if (!(blockEntity instanceof BlastStoveBlockEntity)) continue;
                    BlastStoveBlockEntity fbe = (BlastStoveBlockEntity)blockEntity;
                    fbe.refreshCapability();
                }
            }
        }
        if (this.level.isClientSide) {
            return;
        }
        this.refreshCapability();
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public void tick() {
        HotBlastRecipe recipe;
        super.tick();
        if (this.isController() && !this.primaryInputInventory.isEmpty() && !this.secondaryInputInventory.isEmpty() && this.primaryOutputInventory.getSpace() != 0 && this.secondaryOutputInventory.getSpace() != 0 && (recipe = this.getMatchingRecipes()) != null) {
            if ((float)this.timer >= (float)this.getSpeedModifier() / ((float)this.getTotalTankSize() * 0.3f)) {
                if ((this.primaryOutputInventory.isEmpty() || this.primaryOutputInventory.getFluid().isFluidEqual(recipe.getPrimaryResult())) && (this.secondaryOutputInventory.isEmpty() || this.secondaryOutputInventory.getFluid().isFluidEqual(recipe.getSecondaryResult()))) {
                    this.primaryInputInventory.setFluid(new FluidStack(this.primaryInputInventory.getFluid().copy().getFluidHolder(), this.primaryInputInventory.getFluidAmount() - recipe.getPrimaryIngredient().amount()));
                    this.secondaryInputInventory.setFluid(new FluidStack(this.secondaryInputInventory.getFluid().copy().getFluidHolder(), this.secondaryInputInventory.getFluidAmount() - recipe.getSecondaryIngredient().amount()));
                    this.primaryOutputInventory.setFluid(new FluidStack(recipe.getPrimaryResult().getFluidHolder(), this.primaryOutputInventory.getFluidAmount() + recipe.getPrimaryResult().getAmount()));
                    this.secondaryOutputInventory.setFluid(new FluidStack(recipe.getSecondaryResult().getFluidHolder(), this.secondaryOutputInventory.getFluidAmount() + recipe.getSecondaryResult().getAmount()));
                }
            } else {
                ++this.timer;
            }
        }
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.getBlockPos();
        } else if (!this.lastKnownPos.equals((Object)this.worldPosition) && this.worldPosition != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    public int getSpeedModifier() {
        return 100;
    }

    protected Object getRecipeCacheKey() {
        return HotBlastRecipesKey;
    }

    protected HotBlastRecipe getMatchingRecipes() {
        List list = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.level, (Predicate)RecipeConditions.isOfType((RecipeType[])new RecipeType[]{TFMGRecipeTypes.HOT_BLAST.getType()}));
        for (int i = 0; i < list.toArray().length; ++i) {
            HotBlastRecipe recipe = (HotBlastRecipe)((RecipeHolder)list.get(i)).value();
            if (!recipe.getPrimaryIngredient().test(this.primaryInputInventory.getFluid()) || !recipe.getSecondaryIngredient().test(this.secondaryInputInventory.getFluid())) continue;
            return recipe;
        }
        return null;
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.level.isClientSide) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.worldPosition;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.hasLevel()) {
            return;
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
    }

    public BlastStoveBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity tileEntity = this.level.getBlockEntity(this.controller);
        if (tileEntity instanceof BlastStoveBlockEntity) {
            return (BlastStoveBlockEntity)tileEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
    }

    public void removeController(boolean keepFluids) {
        if (this.level.isClientSide) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onFluidStackChanged(this.primaryOutputInventory.getFluid());
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setController(BlockPos controller) {
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    public void refreshCapability() {
        this.primaryCapability = this.handlerForCapability();
        this.secondaryCapability = this.handlerForSecondaryCapability();
        this.invalidateCapabilities();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? new CombinedTankWrapper(new IFluidHandler[]{this.primaryOutputInventory, this.secondaryInputInventory}) : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new CombinedTankWrapper(new IFluidHandler[]{this.primaryOutputInventory, this.secondaryInputInventory}));
    }

    private IFluidHandler handlerForSecondaryCapability() {
        return this.isController() ? new CombinedTankWrapper(new IFluidHandler[]{this.primaryInputInventory, this.secondaryOutputInventory}) : (this.getControllerBE() != null ? this.getControllerBE().handlerForSecondaryCapability() : new CombinedTankWrapper(new IFluidHandler[]{this.primaryInputInventory, this.secondaryOutputInventory}));
    }

    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().expandTowards((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, registries, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        this.updateConnectivity = compound.contains("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.contains("LastKnownPos")) {
            this.lastKnownPos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)compound, (String)"LastKnownPos").get();
        }
        if (compound.contains("Controller")) {
            this.controller = (BlockPos)NbtUtils.readBlockPos((CompoundTag)compound, (String)"Controller").get();
        }
        if (this.isController()) {
            this.width = compound.getInt("Size");
            this.height = compound.getInt("Height");
            this.primaryOutputInventory.readFromNBT(registries, compound.getCompound("primaryOutputInventory"));
            this.primaryInputInventory.readFromNBT(registries, compound.getCompound("primaryInputInventory"));
            this.secondaryOutputInventory.readFromNBT(registries, compound.getCompound("secondaryOutputInventory"));
            this.secondaryInputInventory.readFromNBT(registries, compound.getCompound("secondaryInputInventory"));
            if (this.primaryOutputInventory.getSpace() < 0) {
                this.primaryOutputInventory.drain(-this.primaryOutputInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.hasLevel()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            }
            this.invalidateRenderBoundingBox();
        }
    }

    public float getFillState() {
        return (float)this.primaryOutputInventory.getFluidAmount() / (float)this.primaryOutputInventory.getCapacity();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.getControllerBE() == null) {
            return false;
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        TFMGTexts.header("blast_stove").forGoggles(tooltip);
        TFMGLang.builder().add(TFMGLang.translate("goggles.blast_stove.tank1", new Object[0])).add(TFMGLang.number(this.getControllerBE().secondaryCapability.getFluidInTank(0).getAmount()).add(mb).add(this.getControllerBE().secondaryCapability.getFluidInTank(0).getFluid() == Fluids.EMPTY ? TFMGLang.text("") : TFMGLang.text(" " + this.getControllerBE().secondaryCapability.getFluidInTank(0).getDisplayName().getString())).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(TFMGLang.number(8000.0).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        TFMGLang.builder().add(TFMGLang.translate("goggles.blast_stove.tank2", new Object[0])).add(TFMGLang.number(this.getControllerBE().primaryCapability.getFluidInTank(1).getAmount()).add(mb).add(this.getControllerBE().primaryCapability.getFluidInTank(1).getFluid() == Fluids.EMPTY ? TFMGLang.text("") : TFMGLang.text(" " + this.getControllerBE().primaryCapability.getFluidInTank(1).getDisplayName().getString())).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(TFMGLang.number(8000.0).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        TFMGLang.builder().add(TFMGLang.translate("goggles.blast_stove.tank3", new Object[0])).add(TFMGLang.number(this.getControllerBE().primaryCapability.getFluidInTank(0).getAmount()).add(mb).add(this.getControllerBE().primaryCapability.getFluidInTank(0).getFluid() == Fluids.EMPTY ? TFMGLang.text("") : TFMGLang.text(" " + this.getControllerBE().primaryCapability.getFluidInTank(0).getDisplayName().getString())).style(ChatFormatting.YELLOW)).text(ChatFormatting.GRAY, " / ").add(TFMGLang.number(8000.0).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        TFMGLang.builder().add(TFMGLang.translate("goggles.blast_stove.tank4", new Object[0])).add(TFMGLang.number(this.getControllerBE().secondaryCapability.getFluidInTank(1).getAmount()).add(mb).add(this.getControllerBE().secondaryCapability.getFluidInTank(1).getFluid() == Fluids.EMPTY ? TFMGLang.text("") : TFMGLang.text(" " + this.getControllerBE().secondaryCapability.getFluidInTank(1).getDisplayName().getString())).style(ChatFormatting.YELLOW)).text(ChatFormatting.GRAY, " / ").add(TFMGLang.number(8000.0).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.putBoolean("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.put("primaryOutputInventory", (Tag)this.primaryOutputInventory.writeToNBT(registries, new CompoundTag()));
            compound.put("primaryInputInventory", (Tag)this.primaryInputInventory.writeToNBT(registries, new CompoundTag()));
            compound.put("secondaryOutputInventory", (Tag)this.secondaryOutputInventory.writeToNBT(registries, new CompoundTag()));
            compound.put("secondaryInputInventory", (Tag)this.secondaryInputInventory.writeToNBT(registries, new CompoundTag()));
            compound.putInt("Size", this.width);
            compound.putInt("Height", this.height);
        }
        this.forEachBehaviour(tb -> tb.write(compound, registries, clientPacket));
        if (!clientPacket) {
            return;
        }
        if (this.queuedSync) {
            compound.putBoolean("LazySync", true);
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.BLAST_STOVE.get(), (be, context) -> {
            if (be.fluidCapability == null) {
                be.refreshCapability();
            }
            if (be.secondaryCapability == null) {
                be.refreshCapability();
            }
            if (context.getAxis() == Direction.Axis.Y) {
                return be.primaryCapability;
            }
            if (be.getController().getY() == be.getBlockPos().getY()) {
                return be.secondaryCapability;
            }
            return null;
        });
    }

    public FluidTank getTankInventory() {
        return this.primaryOutputInventory;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public static int getMaxHeight() {
        return (Integer)AllConfigs.server().fluids.fluidTankMaxHeight.get();
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        this.onFluidStackChanged(this.primaryOutputInventory.getFluid());
        this.updateBoilerState();
        this.setChanged();
        this.updateConnectivity = true;
        this.sendData();
        this.setChanged();
    }

    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean) {
            Boolean windows = (Boolean)data;
            windows = windows | this.window;
            return windows;
        }
        return data;
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return BlastStoveBlockEntity.getMaxHeight();
        }
        return this.getMaxWidth();
    }
}

