/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.metallurgy.blast_furnace;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.lang.TFMGTexts;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.machinery.metallurgy.blast_furnace.BlastFurnaceHatchBlockEntity;
import com.drmangotea.tfmg.datagen.TFMGDamageSources;
import com.drmangotea.tfmg.recipes.IndustrialBlastingRecipe;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.Create;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class BlastFurnaceOutputBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public SmartInventory inputInventory;
    public SmartInventory fluxInventory;
    public FluidTank primaryTank;
    public FluidTank secondaryTank;
    protected IFluidHandler fluidCapability;
    public IItemHandlerModifiable itemCapability;
    public int fuel = 0;
    public int fuelConsumeTimer = 0;
    public float duration;
    public int timer = -1;
    public BlockPos tuyerePos;
    public BlastFurnaceHatchBlockEntity tuyereBE = null;
    public static final int STORAGE_SPACE = 64;
    public LerpedFloat coalCokeHeight = LerpedFloat.linear();
    boolean isReinforced = false;

    public BlastFurnaceOutputBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        this.inputInventory = new SmartInventory(1, (SyncedBlockEntity)this).forbidInsertion().forbidExtraction().withMaxStackSize(64);
        this.fluxInventory = new SmartInventory(1, (SyncedBlockEntity)this).forbidInsertion().forbidExtraction().withMaxStackSize(64).whenContentsChanged(i -> this.onContentsChanged());
        this.primaryTank = new SmartFluidTank(4000, this::onFluidChanged);
        this.secondaryTank = new SmartFluidTank(4000, this::onFluidChanged);
        this.itemCapability = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.fluxInventory});
        this.fluidCapability = new CombinedTankWrapper(new IFluidHandler[]{this.primaryTank, this.secondaryTank});
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.BLAST_FURNACE_OUTPUT.get(), (be, context) -> be.fluidCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.BLAST_FURNACE_OUTPUT.get(), (be, context) -> be.itemCapability);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    private void onFluidChanged(FluidStack stack) {
        if (!this.hasLevel()) {
            return;
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
    }

    public void onContentsChanged() {
        if (!this.inputInventory.isEmpty() && this.timer == -1) {
            this.executeRecipe();
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        TFMGTexts.BlastFurnace.stats(this.inputInventory.getStackInSlot(0).getCount()).forGoggles(tooltip, 1);
        TFMGTexts.BlastFurnace.height(this.getSize()).forGoggles(tooltip, 1);
        TFMGTexts.BlastFurnace.fuelAmount(this.fuel).forGoggles(tooltip, 1);
        if (this.timer != -1) {
            TFMGTexts.BlastFurnace.timer(this.timer).forGoggles(tooltip, 1);
        }
        if (this.isReinforced) {
            TFMGTexts.BlastFurnace.reinforced().forGoggles(tooltip);
        }
        TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
        TFMGUtils.createItemTooltip((BlockEntity)this, tooltip);
        return true;
    }

    public void executeRecipe() {
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandler)this.inputInventory);
        Optional optional = TFMGRecipeTypes.INDUSTRIAL_BLASTING.find(inventoryIn, this.level);
        if (optional.isEmpty()) {
            return;
        }
        IndustrialBlastingRecipe recipe = (IndustrialBlastingRecipe)optional.get().value();
        if (recipe.getIngredients().size() > 1 && !((Ingredient)recipe.getIngredients().get(1)).test(this.fluxInventory.getItem(0))) {
            return;
        }
        if (this.fluxInventory.getItem(0).getCount() < recipe.getIngredients().size() - 1) {
            return;
        }
        int baseDuration = recipe.getProcessingDuration() * 20;
        int heigth = this.getSize();
        int maxHeigth = (Integer)TFMGConfigs.common().machines.blastFurnaceMaxHeight.get();
        double maxTimeModifier = (Double)TFMGConfigs.common().machines.blastFurnaceHeightSpeedModifier.get();
        double timeModifier = (double)maxHeigth / ((double)(baseDuration / 2) * maxTimeModifier);
        this.timer = (int)((double)baseDuration - (double)heigth / timeModifier);
        if (this.isReinforced) {
            this.timer /= 2;
        }
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            this.coalCokeHeight.chase((double)Math.min(this.fuel + this.inputInventory.getStackInSlot(0).getCount(), 24), (double)0.1f, LerpedFloat.Chaser.EXP);
            this.coalCokeHeight.tickChaser();
        }
        if (this.inputInventory.isEmpty()) {
            return;
        }
        if (this.getSize() < 3) {
            return;
        }
        if (this.fuelConsumeTimer >= (Integer)TFMGConfigs.common().machines.blastFurnaceFuelConsumption.get() && this.fuel > 0) {
            this.fuelConsumeTimer = 0;
            --this.fuel;
        }
        if (this.timer > -1) {
            RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandler)this.inputInventory);
            Optional optional = TFMGRecipeTypes.INDUSTRIAL_BLASTING.find(inventoryIn, this.level);
            if (optional.isEmpty()) {
                this.timer = -1;
                return;
            }
            IndustrialBlastingRecipe recipe = (IndustrialBlastingRecipe)optional.get().value();
            if (this.timer == 0 && this.canProcess(recipe)) {
                boolean itemsUsed = true;
                boolean fluxUsed = true;
                if (this.primaryTank.getSpace() < recipe.getPrimaryResult().getAmount()) {
                    return;
                }
                if (recipe.getFluidResults().size() > 1 && this.secondaryTank.getSpace() < recipe.getSecondaryResult().getAmount()) {
                    return;
                }
                this.inputInventory.getItem(0).shrink(1);
                if (recipe.getIngredients().size() > 1) {
                    this.fluxInventory.getItem(0).shrink(recipe.getIngredients().size() - 1);
                }
                this.primaryTank.fill(recipe.getPrimaryResult(), IFluidHandler.FluidAction.EXECUTE);
                if (recipe.getFluidResults().size() > 1) {
                    this.secondaryTank.fill(recipe.getSecondaryResult(), IFluidHandler.FluidAction.EXECUTE);
                }
                this.timer = -1;
                this.sendData();
                this.setChanged();
            }
            if (this.timer > 0 && this.fuel > 0) {
                BlockEntity blockEntity;
                if (!(recipe.hotAirUsage <= 0 || this.tuyerePos != null && this.level.getBlockState(this.tuyerePos).is((Block)TFMGBlocks.BLAST_FURNACE_HATCH.get()))) {
                    this.tuyereBE = null;
                    return;
                }
                if (this.tuyereBE == null && this.tuyerePos != null) {
                    this.tuyereBE = (BlastFurnaceHatchBlockEntity)this.level.getBlockEntity(this.tuyerePos);
                }
                if (!(this.tuyereBE == null || this.tuyereBE.tank.getFluidAmount() >= recipe.hotAirUsage && this.tuyereBE.tank.getFluid().getFluid().isSame((Fluid)TFMGFluids.HOT_AIR.getSource()))) {
                    return;
                }
                if (this.tuyereBE != null) {
                    this.tuyereBE.tank.getFluidInTank(0).setAmount(Math.max(this.tuyereBE.tank.getFluidInTank(0).getAmount() - recipe.hotAirUsage, 0));
                }
                if (!recipe.getGasByproduct().isEmpty() && (blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite()).above(this.getSize()))) instanceof BlastFurnaceHatchBlockEntity) {
                    BlastFurnaceHatchBlockEntity be = (BlastFurnaceHatchBlockEntity)blockEntity;
                    be.tank.fill(recipe.getGasByproduct(), IFluidHandler.FluidAction.EXECUTE);
                }
                if (this.level.isClientSide()) {
                    this.makeParticles();
                }
                this.hurtEntities();
                --this.timer;
                ++this.fuelConsumeTimer;
                if (!this.level.isClientSide) {
                    this.setChanged();
                    this.sendData();
                }
            }
        }
    }

    public void makeParticles() {
        Random random = Create.RANDOM;
        Direction direction = ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite();
        BlockPos pos = this.getBlockPos().above().relative(direction);
        int shouldSpawnSmoke = random.nextInt(7);
        if (shouldSpawnSmoke == 0) {
            this.level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, (double)((float)pos.getX() + random.nextFloat(0.6f)) + 0.2, (double)(pos.getY() + 1), (double)((float)pos.getZ() + random.nextFloat(0.6f)) + 0.2, 0.0, 0.08, 0.0);
        }
    }

    private boolean canProcess(IndustrialBlastingRecipe recipe) {
        if (this.fuel == 0) {
            return false;
        }
        if (!this.primaryTank.getFluid().isEmpty() && !this.primaryTank.getFluid().getFluid().isSame(recipe.getPrimaryResult().getFluid())) {
            return false;
        }
        return this.secondaryTank.getFluid().isEmpty() || this.secondaryTank.getFluid().getFluid().isSame(recipe.getSecondaryResult().getFluid());
    }

    public void lazyTick() {
        super.lazyTick();
        this.onContentsChanged();
        this.collectItems();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.getBlockPos()).setMaxY((double)(this.getBlockPos().getY() + 2));
    }

    public void hurtEntities() {
        List entities = this.level.getEntitiesOfClass(LivingEntity.class, new AABB(this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite()).above()));
        for (LivingEntity entity : entities) {
            if (entity.fireImmune()) continue;
            entity.setRemainingFireTicks(15);
            if (!entity.hurt(TFMGDamageSources.blastFurnace(this.level), 4.0f)) continue;
            entity.playSound(SoundEvents.GENERIC_BURN, 0.4f, 2.0f + entity.getRandom().nextFloat() * 0.4f);
        }
    }

    public void collectItems() {
        List items = this.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite()).above()));
        if (items.isEmpty()) {
            return;
        }
        ItemStack itemStack = ((ItemEntity)items.get(0)).getItem();
        for (int i = 0; i < 64; ++i) {
            if (itemStack.isEmpty()) {
                return;
            }
            if (itemStack.is(TFMGTags.TFMGItemTags.BLAST_FURNACE_FUEL.tag) && this.fuel < 64) {
                ++this.fuel;
                itemStack.shrink(1);
                continue;
            }
            if (itemStack.is(TFMGTags.TFMGItemTags.FLUX.tag) && this.fluxInventory.getItem(0).getCount() < itemStack.getMaxStackSize() && (this.fluxInventory.isEmpty() || this.fluxInventory.getItem(0).is(itemStack.getItem()))) {
                this.fluxInventory.setItem(0, new ItemStack((ItemLike)itemStack.getItem(), this.fluxInventory.getItem(0).getCount() + 1));
                itemStack.shrink(1);
                continue;
            }
            if (this.inputInventory.getItem(0).getCount() >= itemStack.getMaxStackSize() || !this.inputInventory.isEmpty() && !this.inputInventory.getItem(0).is(itemStack.getItem())) continue;
            this.inputInventory.setItem(0, new ItemStack((ItemLike)itemStack.getItem(), this.inputInventory.getItem(0).getCount() + 1));
            itemStack.shrink(1);
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.isReinforced = compound.getBoolean("IsReinforce");
        this.inputInventory.deserializeNBT(registries, compound.getCompound("InputItems"));
        this.fluxInventory.deserializeNBT(registries, compound.getCompound("Flux"));
        this.timer = compound.getInt("Timer");
        this.fuel = compound.getInt("Fuel");
        this.fuelConsumeTimer = compound.getInt("FuelConsumeTimer");
        this.primaryTank.readFromNBT(registries, compound.getCompound("PrimaryTankContent"));
        this.secondaryTank.readFromNBT(registries, compound.getCompound("SecondaryTankContent"));
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putBoolean("IsReinforce", this.isReinforced);
        compound.put("InputItems", (Tag)this.inputInventory.serializeNBT(registries));
        compound.put("Flux", (Tag)this.fluxInventory.serializeNBT(registries));
        compound.putInt("Timer", this.timer);
        compound.putInt("Fuel", this.fuel);
        compound.putInt("FuelConsumeTimer", this.fuelConsumeTimer);
        compound.put("PrimaryTankContent", (Tag)this.primaryTank.writeToNBT(registries, new CompoundTag()));
        compound.put("SecondaryTankContent", (Tag)this.secondaryTank.writeToNBT(registries, new CompoundTag()));
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inputInventory);
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.fluxInventory);
    }

    public int getSize() {
        BlockPos middlePos = this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite());
        this.tuyerePos = null;
        if (this.isValidWall(middlePos) == FurnaceBlockType.NONE) {
            return 0;
        }
        int size = 0;
        int normalAmount = 0;
        int reinforcedAmount = 0;
        for (int i = 0; i < (Integer)TFMGConfigs.common().machines.blastFurnaceMaxHeight.get(); ++i) {
            BlockPos checkedPos = middlePos.above(i).east().south();
            for (int j = 0; j < 3; ++j) {
                for (int y = 0; y < 3; ++y) {
                    FurnaceBlockType wall = this.isValidWall(checkedPos);
                    FurnaceBlockType support = this.isValidSupport(checkedPos);
                    if (checkedPos.getX() == middlePos.getX() ^ checkedPos.getZ() == middlePos.getZ()) {
                        if (i != 0 || !this.level.getBlockState(checkedPos).is((Block)TFMGBlocks.BLAST_FURNACE_OUTPUT.get())) {
                            if (wall == FurnaceBlockType.NONE) {
                                this.isReinforced = normalAmount == 0 && reinforcedAmount > 0;
                                return size;
                            }
                            if (wall == FurnaceBlockType.REGULAR) {
                                ++normalAmount;
                            } else {
                                ++reinforcedAmount;
                            }
                        }
                    } else if (checkedPos.getX() == middlePos.getX() && checkedPos.getZ() == middlePos.getZ()) {
                        if (!this.level.getBlockState(checkedPos).isAir() && i != 0) {
                            this.isReinforced = normalAmount == 0 && reinforcedAmount > 0;
                            return size;
                        }
                    } else {
                        if (support == FurnaceBlockType.NONE) {
                            this.isReinforced = normalAmount == 0 && reinforcedAmount > 0;
                            return size;
                        }
                        if (support == FurnaceBlockType.REGULAR) {
                            ++normalAmount;
                        } else {
                            ++reinforcedAmount;
                        }
                    }
                    checkedPos = checkedPos.west();
                }
                checkedPos = checkedPos.north();
                checkedPos = checkedPos.east(3);
            }
            ++size;
        }
        return size;
    }

    public FurnaceBlockType isValidWall(BlockPos pos) {
        BlockState state = this.level.getBlockState(pos);
        if (state.is((Block)TFMGBlocks.BLAST_FURNACE_HATCH.get())) {
            if (this.tuyerePos != null) {
                return FurnaceBlockType.NONE;
            }
            this.tuyerePos = pos;
        }
        if (state.is(TFMGTags.TFMGBlockTags.REINFORCED_BLAST_FURNACE_WALL.tag)) {
            return FurnaceBlockType.REINFORCED;
        }
        if (state.is(TFMGTags.TFMGBlockTags.BLAST_FURNACE_WALL.tag)) {
            return FurnaceBlockType.REGULAR;
        }
        return FurnaceBlockType.NONE;
    }

    public FurnaceBlockType isValidSupport(BlockPos pos) {
        BlockState state = this.level.getBlockState(pos);
        if (state.is(TFMGTags.TFMGBlockTags.REINFORCED_BLAST_FURNACE_SUPPORT.tag)) {
            return FurnaceBlockType.REINFORCED;
        }
        if (state.is(TFMGTags.TFMGBlockTags.BLAST_FURNACE_SUPPORT.tag)) {
            return FurnaceBlockType.REGULAR;
        }
        return FurnaceBlockType.NONE;
    }

    static enum FurnaceBlockType {
        NONE,
        REGULAR,
        REINFORCED;

    }
}

