/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.voltage_observer;

import com.drmangotea.tfmg.base.blocks.WallMountBlock;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.utilities.voltage_observer.ObservedElectricBehaviour;
import com.drmangotea.tfmg.content.electricity.utilities.voltage_observer.VoltageObserverBlock;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class VoltageObserverBlockEntity
extends ElectricBlockEntity {
    boolean update = false;
    ObservedElectricBehaviour observedElectricBehaviour;

    public VoltageObserverBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.observedElectricBehaviour = new ObservedElectricBehaviour(this);
        behaviours.add(this.observedElectricBehaviour);
    }

    @Override
    public void onNetworkChanged(int oldVoltage, int oldPower) {
        super.onNetworkChanged(oldVoltage, oldPower);
        this.update = true;
    }

    public int getComparatorOutput() {
        return ComparatorUtil.fractionToRedstoneLevel((double)((double)this.getData().getVoltage() / 250.0));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.update) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)VoltageObserverBlock.POWERED, (Comparable)Boolean.valueOf(this.getData().getVoltage() != 0)), 2);
            this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
            this.update = false;
        }
        if (this.observedElectricBehaviour != null) {
            this.observedElectricBehaviour.setObservedPos(this.getConnectedPos());
        }
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == this.getBlockState().getValue((Property)WallMountBlock.FACING);
    }

    private BlockPos getConnectedPos() {
        return this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)WallMountBlock.FACING));
    }
}

