/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.generators;

import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.electricity.base.KineticElectricBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class GeneratorBlockEntity
extends KineticElectricBlockEntity {
    public GeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public int voltageGeneration() {
        return Math.min(255, this.generation());
    }

    @Override
    public int powerGeneration() {
        return this.generation() * 40;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.data.updateNextTick) {
            this.updateNetwork();
            this.data.updateNextTick = false;
        }
    }

    @Override
    public void updateNetwork() {
        super.updateNetwork();
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        this.updateNextTick();
    }

    @Override
    public void onNetworkChanged(int oldVoltage, int oldPower) {
        super.onNetworkChanged(oldVoltage, oldPower);
        this.updateStress();
        this.sendStuff();
    }

    public void updateStress() {
        if (this.getOrCreateNetwork() != null) {
            this.getOrCreateNetwork().remove((KineticBlockEntity)this);
            this.getOrCreateNetwork().add((KineticBlockEntity)this);
        }
    }

    public int generation() {
        float modifier = TFMGConfigs.common().machines.generatorModifier.getF();
        float maxSpeed = TFMGConfigs.common().machines.generatorMinSpeed.getF();
        return (int)Math.max(0.0f, (Math.abs(this.getSpeed()) - maxSpeed) * modifier);
    }
}

