/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.base;

import com.drmangotea.tfmg.content.electricity.base.ElectricBlockValues;
import com.drmangotea.tfmg.content.electricity.base.ElectricalGroup;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.engines.types.regular_engine.RegularEngineBlockEntity;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class KineticElectricBlockEntity
extends GeneratingKineticBlockEntity
implements IElectric,
IHaveGoggleInformation,
IHaveHoveringInformation {
    public ElectricBlockValues data = new ElectricBlockValues(this.getPos());

    public KineticElectricBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.data.connectNextTick = true;
        if (!this.canBeInGroups()) {
            this.data.group = new ElectricalGroup(-1);
        }
    }

    @Override
    public LevelAccessor getLevelAccessor() {
        return this.level;
    }

    public void lazyTick() {
        super.lazyTick();
        this.lazyTickElectricity();
    }

    @Override
    public ElectricBlockValues getData() {
        return this.data;
    }

    @Override
    public void sendStuff() {
        this.sendData();
    }

    @Override
    public long getPos() {
        return this.getBlockPos().asLong();
    }

    public void remove() {
        super.remove();
        this.onRemoved();
    }

    public void tick() {
        super.tick();
        this.tickElectricity();
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        this.writeElectricity(compound, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.readElectricity(compound, clientPacket);
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (this instanceof RegularEngineBlockEntity) {
            this.notifyNetworkAboutSpeedChange();
        }
    }

    public void notifyNetworkAboutSpeedChange() {
        this.updateNextTick();
    }
}

