/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.base.palettes;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.TFMGCreativeTabs;
import com.drmangotea.tfmg.base.palettes.TFMGPaletteBlockPartial;
import com.drmangotea.tfmg.base.palettes.TFMGPaletteBlockPattern;
import com.drmangotea.tfmg.registry.TFMGPaletteStoneTypes;
import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class TFMGPalettesVariantEntry {
    public final ImmutableList<BlockEntry<? extends Block>> registeredBlocks;
    public final ImmutableList<BlockEntry<? extends Block>> registeredPartials;

    public TFMGPalettesVariantEntry(String name, TFMGPaletteStoneTypes paletteStoneVariants) {
        ImmutableList.Builder registeredBlocks = ImmutableList.builder();
        ImmutableList.Builder registeredPartials = ImmutableList.builder();
        NonNullSupplier<Block> baseBlock = paletteStoneVariants.baseBlock;
        for (TFMGPaletteBlockPattern pattern : paletteStoneVariants.variantTypes) {
            TagKey<Item>[] itemTags;
            BlockBuilder builder = ((BlockBuilder)TFMG.REGISTRATE.block(pattern.createName(name), pattern.getBlockFactory()).initialProperties(baseBlock).transform(TagGen.pickaxeOnly())).blockstate((arg_0, arg_1) -> ((TFMGPaletteBlockPattern.IBlockStateProvider)((TFMGPaletteBlockPattern.IBlockStateProvider)((Function)pattern.getBlockStateGenerator().apply(pattern)).apply(name))).accept(arg_0, arg_1));
            ItemBuilder itemBuilder = builder.item();
            TagKey<Block>[] blockTags = pattern.getBlockTags();
            if (blockTags != null) {
                builder.tag(blockTags);
            }
            if ((itemTags = pattern.getItemTags()) != null) {
                itemBuilder.tag(itemTags);
            }
            itemBuilder.tag(new TagKey[]{paletteStoneVariants.materialTag});
            if (pattern.isTranslucent()) {
                builder.addLayer(() -> RenderType::translucent);
            }
            pattern.createCTBehaviour(name).ifPresent(b -> builder.onRegister(CreateRegistrate.connectedTextures((Supplier)b)));
            builder.recipe((c, p) -> {
                p.stonecutting(DataIngredient.tag(paletteStoneVariants.materialTag), RecipeCategory.BUILDING_BLOCKS, (Supplier)c);
                pattern.addRecipes(baseBlock, (DataGenContext<Block, ? extends Block>)c, (RegistrateRecipeProvider)p);
            });
            itemBuilder.register();
            BlockEntry block = builder.register();
            registeredBlocks.add((Object)block);
            for (TFMGPaletteBlockPartial<? extends Block> partialBlock : pattern.getPartials()) {
                registeredPartials.add((Object)partialBlock.create(name, pattern, (BlockEntry<Block>)block, paletteStoneVariants).register());
            }
        }
        TFMG.REGISTRATE.addDataGenerator(ProviderType.RECIPE, p -> p.stonecutting(DataIngredient.tag(paletteStoneVariants.materialTag), RecipeCategory.BUILDING_BLOCKS, (Supplier)baseBlock));
        TFMG.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, p -> p.addTag(paletteStoneVariants.materialTag).add((Object)((Block)baseBlock.get()).asItem()));
        this.registeredBlocks = registeredBlocks.build();
        this.registeredPartials = registeredPartials.build();
    }

    static {
        TFMG.REGISTRATE.setCreativeTab(TFMGCreativeTabs.TFMG_DECORATION);
    }
}

