/*
 * Decompiled with CFR 0.152.
 */
package com.github.Pandarix.beautify.common.block;

import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.NotNull;

public class HangingPot
extends LanternBlock {
    private static final List<Item> validFlowers = Arrays.asList(Items.AIR, Items.ROSE_BUSH, Items.LILAC, Items.BLUE_ORCHID, Items.VINE, Items.SUNFLOWER, Items.PEONY, Items.AZURE_BLUET, Items.RED_TULIP, Items.ORANGE_TULIP, Items.WHITE_TULIP, Items.PINK_TULIP, Items.ALLIUM, Items.DANDELION, Items.POPPY, Items.GLOW_LICHEN, Items.OXEYE_DAISY, Items.LILY_OF_THE_VALLEY, Items.CORNFLOWER, Items.WEEPING_VINES, Items.TWISTING_VINES, Items.WITHER_ROSE, Items.GLOW_BERRIES, Items.SWEET_BERRIES, Items.SHORT_GRASS, Items.FERN);
    public static final IntegerProperty POTFLOWER = IntegerProperty.create((String)"potflower", (int)0, (int)(validFlowers.size() - 1));
    public static final BooleanProperty GROWN = BooleanProperty.create((String)"grown");
    private static final VoxelShape HANGING_SHAPE = Shapes.or((VoxelShape)HangingPot.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), (VoxelShape[])new VoxelShape[]{HangingPot.box((double)3.75, (double)4.0, (double)3.75, (double)12.25, (double)8.0, (double)12.25), HangingPot.box((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)});
    private static final VoxelShape STANDING_SHAPE = Shapes.or((VoxelShape)HangingPot.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), (VoxelShape)HangingPot.box((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0));

    public HangingPot(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POTFLOWER, (Comparable)Integer.valueOf(0))).setValue((Property)GROWN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HANGING) != false ? HANGING_SHAPE : STANDING_SHAPE;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos blockPos, boolean bool) {
        if (((Boolean)state.getValue((Property)GROWN)).booleanValue() && blockPos.equals((Object)pos.below()) && level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)GROWN, (Comparable)Boolean.valueOf(false)), 3);
            ItemEntity Item2 = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)validFlowers.get((Integer)state.getValue((Property)POTFLOWER))));
            level.addFreshEntity((Entity)Item2);
            level.playSound(null, pos, SoundEvents.HANGING_ROOTS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.neighborChanged(state, level, pos, block, blockPos, bool);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pResult) {
        if (pHand == InteractionHand.MAIN_HAND) {
            if (itemStack.getItem().equals(Items.BONE_MEAL) && (Integer)pState.getValue((Property)POTFLOWER) != 0 && !pLevel.getBlockState(pPos.below()).isFaceSturdy((BlockGetter)pLevel, pPos.below(), Direction.UP) && !((Boolean)pState.getValue((Property)GROWN)).booleanValue()) {
                pLevel.playSound(null, pPos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!pPlayer.isCreative()) {
                    itemStack.shrink(1);
                }
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)GROWN, (Comparable)Boolean.valueOf(true)), 3);
                return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
            }
            if (itemStack.canPerformAction(ItemAbilities.SHEARS_HARVEST) && (Integer)pState.getValue((Property)POTFLOWER) != 0 && ((Boolean)pState.getValue((Property)GROWN)).booleanValue()) {
                pLevel.playSound(null, pPos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)GROWN, (Comparable)Boolean.valueOf(false)), 3);
                ItemEntity Item2 = new ItemEntity(pLevel, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), new ItemStack((ItemLike)validFlowers.get((Integer)pState.getValue((Property)POTFLOWER))));
                pLevel.addFreshEntity((Entity)Item2);
                return ItemInteractionResult.SUCCESS;
            }
            if ((Integer)pState.getValue((Property)POTFLOWER) != 0) {
                if (itemStack.isEmpty()) {
                    pPlayer.setItemInHand(pHand, new ItemStack((ItemLike)validFlowers.get((Integer)pState.getValue((Property)POTFLOWER)), (Boolean)pState.getValue((Property)GROWN) != false ? 2 : 1));
                    pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue((Property)POTFLOWER, (Comparable)Integer.valueOf(0))).setValue((Property)GROWN, (Comparable)Boolean.valueOf(false)), 3);
                    pLevel.playSound(null, pPos, SoundEvents.COMPOSTER_READY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return ItemInteractionResult.SUCCESS;
                }
                if (itemStack.is(validFlowers.get((Integer)pState.getValue((Property)POTFLOWER))) && itemStack.getCount() < itemStack.getMaxStackSize()) {
                    itemStack.grow((Boolean)pState.getValue((Property)GROWN) != false ? 2 : 1);
                    pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue((Property)POTFLOWER, (Comparable)Integer.valueOf(0))).setValue((Property)GROWN, (Comparable)Boolean.valueOf(false)), 3);
                    pLevel.playSound(null, pPos, SoundEvents.AZALEA_LEAVES_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.FAIL;
            }
            for (Item flower : validFlowers) {
                if (!itemStack.getItem().equals(flower)) continue;
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)POTFLOWER, (Comparable)Integer.valueOf(validFlowers.indexOf(flower))), 3);
                if (!flower.equals(Items.AIR)) {
                    pLevel.playSound(null, pPos, SoundEvents.AZALEA_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (!pPlayer.isCreative()) {
                    itemStack.shrink(1);
                }
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.FAIL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{POTFLOWER, GROWN});
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (!Screen.hasShiftDown() && !Screen.hasControlDown()) {
            components.add((Component)Component.translatable((String)"tooltip.shift").withStyle(ChatFormatting.YELLOW));
            components.add((Component)Component.translatable((String)"tooltip.control").withStyle(ChatFormatting.YELLOW));
        }
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"hanging_pot.description1").withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"hanging_pot.description2").withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"hanging_pot.description3").withStyle(ChatFormatting.GRAY));
        }
        if (Screen.hasControlDown()) {
            components.add((Component)Component.translatable((String)"hanging_pot.list1").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"hanging_pot.list2").withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, components, flag);
    }
}

