/*
 * Decompiled with CFR 0.152.
 */
package com.github.Pandarix.beautify.common.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BotanistWorkbench
extends HorizontalDirectionalBlock {
    public static final MapCodec<BotanistWorkbench> WORKBENCH_MAP_CODEC = BotanistWorkbench.simpleCodec(BotanistWorkbench::new);
    private static final Map<Direction, VoxelShape> SHAPES_FOR_MODEL = ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.or((VoxelShape)BotanistWorkbench.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)14.25), (VoxelShape)BotanistWorkbench.box((double)9.5, (double)12.0, (double)8.5, (double)13.5, (double)16.0, (double)12.5)), (Object)Direction.SOUTH, (Object)Shapes.or((VoxelShape)BotanistWorkbench.box((double)0.0, (double)0.0, (double)1.75, (double)14.0, (double)12.0, (double)16.0), (VoxelShape)BotanistWorkbench.box((double)2.5, (double)12.0, (double)3.5, (double)6.5, (double)16.0, (double)7.5)), (Object)Direction.WEST, (Object)Shapes.or((VoxelShape)BotanistWorkbench.box((double)0.0, (double)0.0, (double)0.0, (double)14.25, (double)12.0, (double)14.0), (VoxelShape)BotanistWorkbench.box((double)8.5, (double)12.0, (double)2.5, (double)12.5, (double)16.0, (double)6.5)), (Object)Direction.EAST, (Object)Shapes.or((VoxelShape)BotanistWorkbench.box((double)1.75, (double)0.0, (double)2.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape)BotanistWorkbench.box((double)3.5, (double)12.0, (double)9.5, (double)7.5, (double)16.0, (double)13.5)));

    public BotanistWorkbench(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return WORKBENCH_MAP_CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPES_FOR_MODEL.get(blockState.getValue((Property)FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING});
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (!Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.shift").withStyle(ChatFormatting.YELLOW));
        } else {
            components.add((Component)Component.translatable((String)"botanist_workbench.description").withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, components, flag);
    }
}

