/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseContainerBase;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.IContainerFactory;

public abstract class CorpseContainerFactory<T extends CorpseContainerBase>
implements IContainerFactory<T> {
    public T create(int windowId, Inventory inv, RegistryFriendlyByteBuf buffer) {
        boolean isHistory = buffer.readBoolean();
        boolean additionalItemsEmpty = buffer.readBoolean();
        if (isHistory) {
            Death death = Death.fromNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            if (!additionalItemsEmpty) {
                death.getAdditionalItems().add((Object)new ItemStack((ItemLike)Items.STONE));
            }
            return this.create(windowId, inv, CorpseEntity.createFromDeath(inv.player, death), inv.player.getAbilities().instabuild, isHistory);
        }
        UUID uuid = buffer.readUUID();
        double maxDistance = inv.player.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE) + 2.0;
        AABB aabb = inv.player.getBoundingBox().inflate(maxDistance);
        CorpseEntity corpseEntity = inv.player.level().getEntitiesOfClass(CorpseEntity.class, aabb).stream().filter(corpse -> corpse.getUUID().equals(uuid) && (double)corpse.distanceTo((Entity)inv.player) <= maxDistance).findFirst().orElse(null);
        if (corpseEntity != null && !additionalItemsEmpty) {
            corpseEntity.getDeath().getAdditionalItems().add((Object)new ItemStack((ItemLike)Items.STONE));
        }
        return this.create(windowId, inv.player.getInventory(), corpseEntity, true, isHistory);
    }

    public abstract T create(int var1, Inventory var2, @Nullable CorpseEntity var3, boolean var4, boolean var5);
}

