/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.RemotePicture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class PictureItemRenderer {
    public static boolean canRender(ItemStack stack) {
        PictureItem.PictureData pictureData = PictureItem.getPictureData(stack);
        if (pictureData == null) {
            return false;
        }
        RemotePicture picture = ClientPictureStore.getInstance().getServerPicture(pictureData.id());
        return picture.getStatus() == RemotePicture.Status.SUCCESS;
    }

    public void render(@Nullable UUID data, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (data == null) {
            return;
        }
        RemotePicture picture = ClientPictureStore.getInstance().getServerPicture(data);
        matrices.pushPose();
        matrices.translate(0.0f, 0.0f, 0.5f);
        matrices.translate(0.0625f, 0.0625f, 0.0f);
        matrices.scale(0.875f, 0.875f, 0.875f);
        if (picture.getWidth() > picture.getHeight()) {
            float height = (float)picture.getHeight() / (float)picture.getWidth();
            matrices.translate(0.0f, (1.0f - height) / 2.0f, 0.0f);
            matrices.scale(1.0f, height, 1.0f);
        } else {
            float width = (float)picture.getWidth() / (float)picture.getHeight();
            matrices.translate((1.0f - width) / 2.0f, 0.0f, 0.0f);
            matrices.scale(width, 1.0f, 1.0f);
        }
        RenderType renderLayer = RenderType.entityCutoutNoCull((ResourceLocation)picture.getTextureIdentifier());
        VertexConsumer buffer = vertexConsumers.getBuffer(renderLayer);
        PoseStack.Pose matrix = matrices.last();
        Matrix4f matrix4f = matrix.pose();
        buffer.addVertex(matrix4f, 1.0f, 0.0f, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setOverlay(overlay).setLight(light).setNormal(matrix, 0.0f, 0.0f, 1.0f);
        buffer.addVertex(matrix4f, 1.0f, 1.0f, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setOverlay(overlay).setLight(light).setNormal(matrix, 0.0f, 0.0f, 1.0f);
        buffer.addVertex(matrix4f, 0.0f, 1.0f, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setOverlay(overlay).setLight(light).setNormal(matrix, 0.0f, 0.0f, 1.0f);
        buffer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setOverlay(overlay).setLight(light).setNormal(matrix, 0.0f, 0.0f, 1.0f);
        matrices.popPose();
    }

    @Nullable
    public UUID getData(ItemStack stack) {
        PictureItem.PictureData pictureData = PictureItem.getPictureData(stack);
        return pictureData != null ? pictureData.id() : null;
    }
}

