/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.UUID;
import me.chrr.camerapture.entity.PictureFrameEntity;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.RemotePicture;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.joml.Vector3d;

public class PictureFrameEntityRenderer
extends EntityRenderer<PictureFrameEntity> {
    public static final double DISTANCE_FROM_WALL = 0.01;

    public PictureFrameEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(PictureFrameEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        PictureItem.PictureData pictureData;
        EntityHitResult hitResult;
        HitResult hitResult2;
        boolean shouldRenderOutline;
        matrices.pushPose();
        Vec3 offset = this.getPositionOffset(entity, tickDelta).reverse();
        matrices.translate(offset.x, offset.y, offset.z);
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        matrices.translate(0.5 - (double)entity.getFrameWidth() / 2.0, -0.5 + (double)entity.getFrameHeight() / 2.0, 0.0);
        Minecraft client = Minecraft.getInstance();
        boolean bl = shouldRenderOutline = !this.entityRenderDispatcher.options.hideGui && CameraItem.find((Player)client.player, true) == null && (hitResult2 = client.hitResult) instanceof EntityHitResult && (hitResult = (EntityHitResult)hitResult2).getEntity() == entity;
        if (shouldRenderOutline) {
            this.renderOutline(matrices, vertexConsumers, entity.getFrameWidth(), entity.getFrameHeight());
        }
        matrices.translate(0.0, 0.0, 0.02625);
        UUID pictureId = null;
        ItemStack stack = entity.getItemStack();
        if (stack != null && (pictureData = PictureItem.getPictureData(stack)) != null) {
            pictureId = pictureData.id();
        }
        if (pictureId == null) {
            this.renderErrorText(matrices, vertexConsumers, light);
        } else {
            RemotePicture picture = ClientPictureStore.getInstance().getServerPicture(pictureId);
            if (picture == null || picture.getStatus() == RemotePicture.Status.ERROR) {
                this.renderErrorText(matrices, vertexConsumers, light);
            } else if (picture.getStatus() == RemotePicture.Status.FETCHING) {
                this.renderFetching(matrices, vertexConsumers, light);
            } else {
                matrices.mulPose(Axis.ZP.rotationDegrees(90.0f * (float)entity.getRotation()));
                this.renderPicture(matrices, vertexConsumers, picture, entity, light);
            }
        }
        matrices.popPose();
        super.render((Entity)entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public void renderPicture(PoseStack matrices, MultiBufferSource vertexConsumers, RemotePicture picture, PictureFrameEntity entity, int light) {
        float scale = PictureFrameEntityRenderer.getPictureScale(picture, entity);
        float width = (float)picture.getWidth() * scale;
        float height = (float)picture.getHeight() * scale;
        float x1 = -width / 2.0f;
        float x2 = width / 2.0f;
        float y1 = -height / 2.0f;
        float y2 = height / 2.0f;
        RenderType renderLayer = entity.isPictureGlowing() ? RenderType.text((ResourceLocation)picture.getTextureIdentifier()) : RenderType.entityCutout((ResourceLocation)picture.getTextureIdentifier());
        VertexConsumer buffer = vertexConsumers.getBuffer(renderLayer);
        PoseStack.Pose matrix = matrices.last();
        Matrix4f matrix4f = matrix.pose();
        int effectiveLight = entity.isPictureGlowing() ? 255 : light;
        buffer.addVertex(matrix4f, x1, y1, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(effectiveLight).setNormal(matrix, 0.0f, 0.0f, 1.0f);
        buffer.addVertex(matrix4f, x1, y2, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(effectiveLight).setNormal(matrix, 0.0f, 0.0f, 1.0f);
        buffer.addVertex(matrix4f, x2, y2, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(effectiveLight).setNormal(matrix, 0.0f, 0.0f, 1.0f);
        buffer.addVertex(matrix4f, x2, y1, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(effectiveLight).setNormal(matrix, 0.0f, 0.0f, 1.0f);
    }

    private static float getPictureScale(RemotePicture picture, PictureFrameEntity entity) {
        float pictureWidth = picture.getWidth();
        float pictureHeight = picture.getHeight();
        if (entity.getRotation() % 2 == 1) {
            pictureWidth = picture.getHeight();
            pictureHeight = picture.getWidth();
        }
        float scaledWidth = (float)entity.getFrameWidth() / pictureWidth;
        float scaleHeight = (float)entity.getFrameHeight() / pictureHeight;
        return Math.min(scaledWidth, scaleHeight);
    }

    public void renderOutline(PoseStack matrices, MultiBufferSource vertexConsumers, float frameWidth, float frameHeight) {
        VoxelShape shape = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)frameWidth, (double)frameHeight, (double)0.0625);
        LevelRenderer.renderVoxelShape((PoseStack)matrices, (VertexConsumer)vertexConsumers.getBuffer(RenderType.lines()), (VoxelShape)shape, (double)(-frameWidth / 2.0f), (double)(-frameHeight / 2.0f), (double)-0.03125, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f, (boolean)true);
    }

    public void renderFetching(PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        matrices.scale(-0.015625f, -0.015625f, 0.015625f);
        String loading = LoadingDotsText.get((long)System.currentTimeMillis());
        MutableComponent fetching = Component.translatable((String)"text.camerapture.fetching_picture");
        Font font = this.getFont();
        Objects.requireNonNull(this.getFont());
        this.drawCenteredText(font, (Component)fetching, 0.0f, (float)(-9) - 0.5f, -1, matrices, vertexConsumers, light);
        this.drawCenteredText(this.getFont(), (Component)Component.literal((String)loading), 0.0f, 0.5f, -8355712, matrices, vertexConsumers, light);
    }

    public void renderErrorText(PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        matrices.scale(-0.015625f, -0.015625f, 0.015625f);
        MutableComponent text = Component.translatable((String)"text.camerapture.fetching_failed").withStyle(ChatFormatting.RED);
        Font font = this.getFont();
        Objects.requireNonNull(this.getFont());
        this.drawCenteredText(font, (Component)text, 0.0f, (float)(-9) / 2.0f, -1, matrices, vertexConsumers, light);
    }

    private void drawCenteredText(Font textRenderer, Component text, float x, float y, int color, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        float width = textRenderer.width((FormattedText)text);
        textRenderer.drawInBatch(text, x - width / 2.0f, y, color, false, matrices.last().pose(), vertexConsumers, Font.DisplayMode.NORMAL, 0x7F000000, light);
    }

    public ResourceLocation getTexture(PictureFrameEntity entity) {
        return null;
    }

    public Vec3 getPositionOffset(PictureFrameEntity entity, float tickDelta) {
        Vector3d extra = entity.getNearestViewDirection().getRotation().transform(new Vector3d((double)(((float)entity.getFrameWidth() - 1.0f) / 2.0f), 0.0, (double)(-entity.getFrameHeight() + 2)));
        return new Vec3((double)((float)entity.getNearestViewDirection().getStepX() * 0.3f) + extra.x, 0.75 + extra.y, (double)((float)entity.getNearestViewDirection().getStepZ() * 0.3f) + extra.z);
    }

    protected boolean hasLabel(PictureFrameEntity entity) {
        return Minecraft.renderNames() && super.shouldShowName((Entity)entity);
    }
}

