/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.picture;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import javax.imageio.ImageIO;
import me.chrr.camerapture.ByteCollector;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.CameraptureClient;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.net.serverbound.NewPicturePacket;
import me.chrr.camerapture.net.serverbound.UploadPartialPicturePacket;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.util.ImageUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class PictureTaker {
    private static final PictureTaker INSTANCE = new PictureTaker();
    public float zoomLevel = 1.0f;
    private boolean hudWasHidden = false;
    private boolean takingPicture = false;
    private BufferedImage picture;

    private PictureTaker() {
    }

    public void takePicture() {
        if (this.takingPicture) {
            return;
        }
        if (!Camerapture.PLATFORM.canTakePicture()) {
            return;
        }
        this.takingPicture = true;
        this.hudWasHidden = Minecraft.getInstance().options.hideGui;
        Minecraft.getInstance().options.hideGui = true;
    }

    public void tryUploadFile(Path filePath) {
        block2: {
            try {
                this.picture = ImageIO.read(filePath.toFile());
                Camerapture.NETWORK.sendToServer(new NewPicturePacket());
            }
            catch (Exception e) {
                Camerapture.LOGGER.error("failed to read picture from file", (Throwable)e);
                LocalPlayer player = Minecraft.getInstance().player;
                if (player == null) break block2;
                player.displayClientMessage((Component)Component.translatable((String)"text.camerapture.upload_failed").withStyle(ChatFormatting.RED), false);
            }
        }
    }

    public void renderTickEnd() {
        CameraItem.HeldCamera activeCamera;
        if (!this.takingPicture) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        this.takingPicture = false;
        client.options.hideGui = this.hudWasHidden;
        try (NativeImage nativeImage = Screenshot.takeScreenshot((RenderTarget)client.getMainRenderTarget());){
            this.picture = ImageUtil.fromNativeImage(nativeImage);
        }
        if (Camerapture.CONFIG_MANAGER.getConfig().client.saveScreenshot) {
            Screenshot.grab((File)client.gameDirectory, (RenderTarget)client.getMainRenderTarget(), text -> {});
        }
        if ((activeCamera = CameraItem.find((Player)client.player, true)) != null) {
            CameraItem.setActive(activeCamera.stack(), false);
        }
        Camerapture.NETWORK.sendToServer(new NewPicturePacket());
    }

    public void uploadStoredPicture(UUID pictureId) {
        block5: {
            if (this.picture == null) {
                Camerapture.LOGGER.error("server requested a picture, but we don't have any stored");
                return;
            }
            try {
                BufferedImage picture = ImageUtil.clampSize(this.picture, CameraptureClient.syncedConfig.maxImageResolution());
                picture = ImageUtil.normalize(picture);
                float factor = 1.0f;
                byte[] bytes = ImageUtil.compressIntoWebP(picture, factor);
                while (bytes.length > CameraptureClient.syncedConfig.maxImageBytes()) {
                    if (factor < 0.1f) {
                        throw new IOException("image too big, even at 10% compression (" + bytes.length + " bytes)");
                    }
                    bytes = ImageUtil.compressIntoWebP(picture, factor -= 0.05f);
                }
                Camerapture.LOGGER.debug("sending picture ({} bytes, {}%)", (Object)bytes.length, (Object)((int)(factor * 100.0f)));
                ByteCollector.split(bytes, 30000, (section, bytesLeft) -> Camerapture.NETWORK.sendToServer(new UploadPartialPicturePacket(pictureId, section, bytesLeft)));
                ClientPictureStore.getInstance().processReceivedImage(pictureId, picture);
                ClientPictureStore.getInstance().cacheBytesToDisk(pictureId, bytes);
                this.picture = null;
            }
            catch (Exception e) {
                Camerapture.LOGGER.error("failed to send picture to server", (Throwable)e);
                this.picture = null;
                LocalPlayer player = Minecraft.getInstance().player;
                if (player == null) break block5;
                player.displayClientMessage((Component)Component.translatable((String)"text.camerapture.upload_failed").withStyle(ChatFormatting.RED), false);
            }
        }
    }

    public void zoom(float delta) {
        this.zoomLevel += delta;
        this.zoomLevel = Math.max(1.0f, Math.min(6.0f, this.zoomLevel));
    }

    public float getFovModifier() {
        float zoomProgress = (this.zoomLevel - 1.0f) / 5.0f;
        return 0.1f + 0.9f * (float)Math.pow(1.0f - zoomProgress, 2.0);
    }

    public float getSensitivityModifier() {
        float zoomProgress = (this.zoomLevel - 1.0f) / 5.0f;
        float multiplier = 1.0f - Camerapture.CONFIG_MANAGER.getConfig().client.zoomMouseSensitivity;
        return 1.0f - zoomProgress * multiplier;
    }

    public static PictureTaker getInstance() {
        return INSTANCE;
    }
}

