/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.neoforge;

import java.util.List;
import java.util.Objects;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.CameraptureClient;
import me.chrr.camerapture.compat.ClothConfigScreenFactory;
import me.chrr.camerapture.config.SyncedConfig;
import me.chrr.camerapture.gui.AlbumLecternScreen;
import me.chrr.camerapture.gui.AlbumScreen;
import me.chrr.camerapture.gui.CameraViewFinder;
import me.chrr.camerapture.gui.PictureFrameScreen;
import me.chrr.camerapture.gui.PictureScreen;
import me.chrr.camerapture.gui.UploadScreen;
import me.chrr.camerapture.item.AlbumItem;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.PictureTaker;
import me.chrr.camerapture.render.PictureFrameEntityRenderer;
import me.chrr.camerapture.render.PictureItemRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.jetbrains.annotations.NotNull;

@Mod(value="camerapture", dist={Dist.CLIENT})
public class CameraptureClientNeoForge {
    public CameraptureClientNeoForge(ModContainer mod) {
        Objects.requireNonNull(mod.getEventBus()).register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new ClientEvents());
        if (ModList.get().isLoaded("cloth_config")) {
            mod.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(container, parent) -> ClothConfigScreenFactory.create(parent)));
        }
    }

    @SubscribeEvent
    public void setup(FMLClientSetupEvent event) {
        CameraptureClient.init();
        ItemProperties.register((Item)Camerapture.PICTURE, (ResourceLocation)Camerapture.id("should_render_picture"), (stack, world, entity, seed) -> PictureItemRenderer.canRender(stack) ? 1.0f : 0.0f);
    }

    @SubscribeEvent
    public void registerHandledScreens(RegisterMenuScreensEvent event) {
        event.register(Camerapture.PICTURE_FRAME_SCREEN_HANDLER, PictureFrameScreen::new);
        event.register(Camerapture.ALBUM_SCREEN_HANDLER, AlbumScreen::new);
        event.register(Camerapture.ALBUM_LECTERN_SCREEN_HANDLER, AlbumLecternScreen::new);
    }

    @SubscribeEvent
    public void registerPackets(RegisterPayloadHandlersEvent event) {
        CameraptureClient.registerPacketHandlers();
    }

    @SubscribeEvent
    public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(Camerapture.PICTURE_FRAME, PictureFrameEntityRenderer::new);
    }

    @SubscribeEvent
    public void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(this){

            public HumanoidModel.ArmPose getArmPose(@NotNull LivingEntity entity, @NotNull InteractionHand hand, @NotNull ItemStack stack) {
                return CameraItem.isActive(stack) ? HumanoidModel.ArmPose.BOW_AND_ARROW : null;
            }
        }, new Item[]{Camerapture.CAMERA});
    }

    private static class ClientEvents {
        private ClientEvents() {
        }

        @SubscribeEvent
        public void onAttack(InputEvent.InteractionKeyMappingTriggered event) {
            if (!event.isAttack()) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            CameraItem.HeldCamera camera = CameraItem.find((Player)player, true);
            if (camera == null) {
                return;
            }
            if (CameraItem.canTakePicture((Player)player)) {
                PictureTaker.getInstance().takePicture();
            }
            event.setSwingHand(false);
            event.setCanceled(true);
        }

        @SubscribeEvent
        public InteractionResult onUseItem(PlayerInteractEvent.RightClickItem event) {
            if (event.getSide() != LogicalSide.CLIENT) {
                return InteractionResult.PASS;
            }
            ItemStack stack = event.getItemStack();
            Player player = event.getEntity();
            Minecraft client = Minecraft.getInstance();
            if (client.player != player) {
                return InteractionResult.PASS;
            }
            if (stack.is(Camerapture.PICTURE)) {
                if (PictureItem.getPictureData(stack) != null) {
                    client.executeIfPossible(() -> client.setScreen((Screen)new PictureScreen(List.of(stack))));
                    return InteractionResult.SUCCESS;
                }
            } else if (stack.is(Camerapture.ALBUM) && !player.isShiftKeyDown()) {
                List<ItemStack> pictures = AlbumItem.getPictures(stack);
                if (!pictures.isEmpty()) {
                    client.executeIfPossible(() -> client.setScreen((Screen)new PictureScreen(pictures)));
                    return InteractionResult.SUCCESS;
                }
            } else if (player.hasPermissions(CameraptureClient.syncedConfig.permissionLevels().upload) && player.isShiftKeyDown() && stack.is(Camerapture.CAMERA) && !CameraItem.isActive(stack) && !player.getCooldowns().isOnCooldown(Camerapture.CAMERA)) {
                client.executeIfPossible(() -> client.setScreen((Screen)new UploadScreen()));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }

        @SubscribeEvent
        public void onRenderTickEnd(RenderFrameEvent.Post event) {
            PictureTaker.getInstance().renderTickEnd();
        }

        @SubscribeEvent
        public void onDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
            ClientPictureStore.getInstance().clear();
            CameraptureClient.syncedConfig = SyncedConfig.fromServerConfig(Camerapture.CONFIG_MANAGER.getConfig().server);
        }

        @SubscribeEvent
        public void onRenderHand(RenderHandEvent event) {
            CameraItem.HeldCamera camera = CameraItem.find((Player)Minecraft.getInstance().player, true);
            if (camera != null) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public void onRenderGui(RenderGuiLayerEvent.Pre event) {
            CameraItem.HeldCamera camera = CameraItem.find((Player)Minecraft.getInstance().player, true);
            if (camera == null) {
                PictureTaker.getInstance().zoomLevel = 1.0f;
                return;
            }
            event.setCanceled(true);
            if (event.getName() == VanillaGuiLayers.CROSSHAIR && !Minecraft.getInstance().options.hideGui) {
                CameraViewFinder.drawCameraViewFinder(event.getGuiGraphics(), Minecraft.getInstance().font);
            }
        }

        @SubscribeEvent
        public void onScroll(InputEvent.MouseScrollingEvent event) {
            if (CameraItem.find((Player)Minecraft.getInstance().player, true) != null) {
                PictureTaker.getInstance().zoom((float)(event.getScrollDeltaY() / 4.0));
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public void onFovModifier(ComputeFovModifierEvent event) {
            if (CameraItem.find((Player)Minecraft.getInstance().player, true) != null) {
                event.setNewFovModifier(PictureTaker.getInstance().getFovModifier());
            }
        }

        @SubscribeEvent
        public void onClientTick(ClientTickEvent.Pre event) {
            ClientPictureStore.getInstance().processQueue();
        }
    }
}

