/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.gui;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.RemotePicture;
import me.chrr.camerapture.util.PictureDrawingUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class PictureScreen
extends Screen {
    public static final int MAX_BAR_WIDTH = 360;
    public static final int BORDER_THICKNESS = 24;
    private List<ItemStack> pictures;
    private int index = 0;
    private RemotePicture picture;
    private Component pageNumber;
    private Component customName;
    private boolean ctrlHeld = false;

    public PictureScreen(List<ItemStack> pictures) {
        super((Component)Component.translatable((String)"item.camerapture.picture"));
        this.pictures = pictures;
        this.forceRefresh();
    }

    protected void init() {
        super.init();
        if (!this.isSinglePicture()) {
            int barWidth = Math.min(360, this.width - 48);
            int barX = this.width / 2 - barWidth / 2;
            int barY = this.height - 24 - 20;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.nullToEmpty((String)"\u2190"), button -> this.changeIndexBy(-1)).bounds(barX, barY, 20, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.nullToEmpty((String)"\u2192"), button -> this.changeIndexBy(1)).bounds(barX + barWidth - 20, barY, 20, 20).build());
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        if (!this.isSinglePicture()) {
            int barY = this.height - 24 - 10;
            int pageNumberX = this.width / 2 - this.font.width((FormattedText)this.pageNumber) / 2;
            if (this.customName != null) {
                int nameX = this.width / 2 - this.font.width((FormattedText)this.customName) / 2;
                Objects.requireNonNull(this.font);
                context.drawString(this.font, this.customName, nameX, barY - 1 - 9, 0xFFFFFF, false);
                context.drawString(this.font, this.pageNumber, pageNumberX, barY + 1, 0xFFFFFF, false);
            } else {
                Objects.requireNonNull(this.font);
                context.drawString(this.font, this.pageNumber, pageNumberX, barY - 9 / 2, 0xFFFFFF, false);
            }
        }
        if (this.picture == null) {
            return;
        }
        if (this.ctrlHeld) {
            MutableComponent text = Component.translatable((String)"text.camerapture.save_as").withStyle(ChatFormatting.GRAY);
            int tw = this.font.width((FormattedText)text);
            int n = this.width / 2 - tw / 2;
            Objects.requireNonNull(this.font);
            context.drawString(this.font, (Component)text, n, 24 - 9 - 2, 0xFFFFFF, false);
        }
        int bottomOffset = this.isSinglePicture() ? 0 : 24;
        PictureDrawingUtil.drawPicture(context, this.font, this.picture, 24, 24, this.width - 48, this.height - 48 - bottomOffset);
    }

    @Nullable
    public NativeImage getNativeImage() {
        if (this.minecraft == null || this.picture == null || this.picture.getStatus() != RemotePicture.Status.SUCCESS) {
            return null;
        }
        AbstractTexture texture = this.minecraft.getTextureManager().getTexture(this.picture.getTextureIdentifier());
        if (!(texture instanceof DynamicTexture)) {
            return null;
        }
        DynamicTexture backedTexture = (DynamicTexture)texture;
        return backedTexture.getPixels();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            this.ctrlHeld = true;
        } else if (keyCode == 83 && (modifiers & 2) != 0) {
            NativeImage image = this.getNativeImage();
            if (image != null) {
                this.saveAs(image);
                return true;
            }
        } else {
            if (keyCode == 263) {
                this.changeIndexBy(-1);
                return true;
            }
            if (keyCode == 262) {
                this.changeIndexBy(1);
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            this.ctrlHeld = false;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.changeIndexBy((int)(-verticalAmount));
        return true;
    }

    public void changeIndexBy(int delta) {
        if (!this.pictures.isEmpty()) {
            this.index = Math.floorMod(this.index + delta, this.pictures.size());
            this.forceRefresh();
        }
    }

    public void setPictures(List<ItemStack> pictures) {
        this.pictures = pictures;
        this.index = 0;
        this.rebuildWidgets();
        this.forceRefresh();
    }

    private void forceRefresh() {
        this.pageNumber = Component.literal((String)(this.index + 1 + " / " + this.pictures.size())).withStyle(ChatFormatting.GRAY);
        if (this.index >= this.pictures.size()) {
            this.picture = null;
            this.customName = null;
            return;
        }
        ItemStack stack = this.pictures.get(this.index);
        PictureItem.PictureData pictureData = PictureItem.getPictureData(stack);
        if (pictureData == null) {
            return;
        }
        this.picture = ClientPictureStore.getInstance().ensureRemotePicture(pictureData.id());
        this.customName = (Component)stack.get(DataComponents.CUSTOM_NAME);
    }

    private boolean isSinglePicture() {
        return this.pictures.size() == 1;
    }

    private void saveAs(NativeImage image) {
        new Thread(() -> {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer filter = stack.mallocPointer(1);
                filter.put(stack.UTF8((CharSequence)"png"));
                filter.flip();
                String path = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)"Save Picture", (CharSequence)"picture.png", (PointerBuffer)filter, (CharSequence)"*.png");
                if (path == null) {
                    return;
                }
                try {
                    image.writeToFile(Path.of(path, new String[0]));
                }
                catch (IOException e) {
                    Camerapture.LOGGER.error("failed to save picture to disk", (Throwable)e);
                }
            }
        }, "Save prompter").start();
    }
}

