/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture;

import com.mojang.serialization.Codec;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import me.chrr.camerapture.ByteCollector;
import me.chrr.camerapture.DownloadQueue;
import me.chrr.camerapture.PlatformAdapter;
import me.chrr.camerapture.config.ConfigManager;
import me.chrr.camerapture.entity.PictureFrameEntity;
import me.chrr.camerapture.gui.AlbumLecternScreenHandler;
import me.chrr.camerapture.gui.AlbumScreenHandler;
import me.chrr.camerapture.gui.PictureFrameScreenHandler;
import me.chrr.camerapture.item.AlbumCloningRecipe;
import me.chrr.camerapture.item.AlbumItem;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.item.PictureCloningRecipe;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.net.NetworkAdapter;
import me.chrr.camerapture.net.clientbound.PictureErrorPacket;
import me.chrr.camerapture.net.clientbound.RequestUploadPacket;
import me.chrr.camerapture.net.serverbound.NewPicturePacket;
import me.chrr.camerapture.net.serverbound.RequestDownloadPacket;
import me.chrr.camerapture.net.serverbound.UploadPartialPicturePacket;
import me.chrr.camerapture.picture.ServerPictureStore;
import me.chrr.camerapture.picture.StoredPicture;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Camerapture {
    public static final String MOD_ID = "camerapture";
    public static final Logger LOGGER = LogManager.getLogger((String)"Camerapture");
    public static final Executor EXECUTOR = Executors.newCachedThreadPool();
    public static final ConfigManager CONFIG_MANAGER = new ConfigManager();
    public static final PlatformAdapter PLATFORM = ServiceLoader.load(PlatformAdapter.class).iterator().next();
    public static final NetworkAdapter NETWORK = PLATFORM.createNetworkAdapter();
    public static final int CLIENT_SECTION_SIZE = 30000;
    public static final int SERVER_SECTION_SIZE = 1000000;
    public static Item CAMERA = new CameraItem();
    public static final SoundEvent CAMERA_SHUTTER = SoundEvent.createVariableRangeEvent((ResourceLocation)Camerapture.id("camera_shutter"));
    public static final ResourceLocation PICTURES_TAKEN = Camerapture.id("pictures_taken");
    public static Item PICTURE = new PictureItem();
    public static final SimpleCraftingRecipeSerializer<PictureCloningRecipe> PICTURE_CLONING = new SimpleCraftingRecipeSerializer(PictureCloningRecipe::new);
    public static final Item ALBUM = new AlbumItem();
    public static final MenuType<AlbumScreenHandler> ALBUM_SCREEN_HANDLER = new MenuType(AlbumScreenHandler::new, FeatureFlagSet.of());
    public static final MenuType<AlbumLecternScreenHandler> ALBUM_LECTERN_SCREEN_HANDLER = new MenuType((syncId, playerInventory) -> new AlbumLecternScreenHandler(syncId), FeatureFlagSet.of());
    public static final SimpleCraftingRecipeSerializer<AlbumCloningRecipe> ALBUM_CLONING = new SimpleCraftingRecipeSerializer(AlbumCloningRecipe::new);
    public static final EntityType<PictureFrameEntity> PICTURE_FRAME = EntityType.Builder.of(PictureFrameEntity::new, (MobCategory)MobCategory.MISC).clientTrackingRange(10).sized(0.5f, 0.5f).eyeHeight(0.0f).build("picture_frame");
    public static final MenuType<PictureFrameScreenHandler> PICTURE_FRAME_SCREEN_HANDLER = new MenuType((syncId, pi) -> new PictureFrameScreenHandler(syncId), FeatureFlagSet.of());
    public static final DataComponentType<PictureItem.PictureData> PICTURE_DATA = DataComponentType.builder().persistent(PictureItem.PictureData.CODEC).networkSynchronized(PictureItem.PictureData.PACKET_CODEC).build();
    public static final DataComponentType<Boolean> CAMERA_ACTIVE = DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build();

    public static void registerPacketHandlers() {
        NETWORK.onReceiveFromClient(NewPicturePacket.class, (packet, player) -> {
            CameraItem.HeldCamera camera = CameraItem.find((Player)player, false);
            if (camera == null) {
                return;
            }
            if (!player.isCreative() && ContainerHelper.clearOrCountMatchingItems((Container)player.getInventory(), stack -> stack.is(Items.PAPER), (int)1, (boolean)false) != 1) {
                return;
            }
            if (CameraItem.isActive(camera.stack())) {
                player.serverLevel().playSound(null, (Entity)player, CAMERA_SHUTTER, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            CameraItem.setActive(camera.stack(), false);
            player.getCooldowns().addCooldown(CAMERA, 60);
            player.swing(camera.hand(), true);
            player.awardStat(PICTURES_TAKEN);
            UUID id = ServerPictureStore.getInstance().reserveId();
            NETWORK.sendToClient((ServerPlayer)player, new RequestUploadPacket(id));
        });
        ConcurrentHashMap collectors = new ConcurrentHashMap();
        NETWORK.onReceiveFromClient(UploadPartialPicturePacket.class, (packet, player) -> {
            ByteCollector collector;
            if (!ServerPictureStore.getInstance().isReserved(packet.uuid())) {
                LOGGER.error("{} tried to send a byte section for an unreserved UUID", (Object)player.getName().toString());
                return;
            }
            if (packet.bytesLeft() > Camerapture.CONFIG_MANAGER.getConfig().server.maxImageBytes) {
                LOGGER.error("{} sent a picture exceeding the size limit", (Object)player.getName().getString());
                collectors.remove(packet.uuid());
                ServerPictureStore.getInstance().unreserveId(packet.uuid());
            }
            Object object = collectors;
            synchronized (object) {
                collector = collectors.computeIfAbsent(packet.uuid(), uuid -> new ByteCollector(bytes -> {
                    collectors.remove(uuid);
                    EXECUTOR.execute(() -> {
                        try {
                            MinecraftServer server = player.getServer();
                            if (server == null) {
                                return;
                            }
                            ServerPictureStore.getInstance().put(server, (UUID)uuid, new StoredPicture((byte[])bytes));
                            ItemStack picture = PictureItem.create(player.getName().getString(), uuid);
                            server.execute(() -> player.getInventory().placeItemBackInInventory(picture));
                        }
                        catch (Exception e) {
                            LOGGER.error("failed to save picture from {}", (Object)player.getName().getString(), (Object)e);
                            player.displayClientMessage((Component)Component.translatable((String)"text.camerapture.picture_failed").withStyle(ChatFormatting.RED), false);
                        }
                    });
                }));
            }
            object = collector;
            synchronized (object) {
                if (!collector.push(packet.bytes(), packet.bytesLeft())) {
                    LOGGER.error("{} sent a malformed byte section", (Object)player.getName().getString());
                    collectors.remove(packet.uuid());
                    ServerPictureStore.getInstance().unreserveId(packet.uuid());
                }
                if (collector.getCurrentLength() > Camerapture.CONFIG_MANAGER.getConfig().server.maxImageBytes) {
                    LOGGER.error("{} sent a picture exceeding the size limit", (Object)player.getName().getString());
                    collectors.remove(packet.uuid());
                    ServerPictureStore.getInstance().unreserveId(packet.uuid());
                }
            }
        });
        NETWORK.onReceiveFromClient(RequestDownloadPacket.class, (packet, player) -> {
            try {
                StoredPicture picture = ServerPictureStore.getInstance().get(player.getServer(), packet.uuid());
                if (picture == null) {
                    LOGGER.warn("{} requested a picture with an unknown UUID", (Object)player.getName().getString());
                    NETWORK.sendToClient((ServerPlayer)player, new PictureErrorPacket(packet.uuid()));
                    return;
                }
                DownloadQueue.getInstance().send((ServerPlayer)player, packet.uuid(), picture);
            }
            catch (Exception e) {
                LOGGER.error("failed to load picture for {}", (Object)player.getName().getString(), (Object)e);
                NETWORK.sendToClient((ServerPlayer)player, new PictureErrorPacket(packet.uuid()));
            }
        });
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

