/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public abstract class ModelParticle
extends Particle {
    protected final Minecraft minecraft = Minecraft.getInstance();

    protected ModelParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    public ModelParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        MultiBufferSource.BufferSource bufferSource = this.minecraft.renderBuffers().bufferSource();
        PoseStack poseStack = new PoseStack();
        Vec3 cameraPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPos.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPos.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPos.z());
        poseStack.translate(x, y, z);
        poseStack.scale(1.0f, -1.0f, -1.0f);
        this.render(poseStack, consumer, bufferSource, camera, partialTicks);
    }

    protected abstract void render(PoseStack var1, VertexConsumer var2, MultiBufferSource.BufferSource var3, Camera var4, float var5);

    protected <T extends Model> T bakeModel(Function<ModelPart, T> modelBaker, ModelLayerLocation layerLocation) {
        return (T)((Model)modelBaker.apply(this.minecraft.getEntityModels().bakeLayer(layerLocation)));
    }

    protected ResourceLocation getSpriteId(TextureAtlasSprite sprite) {
        return sprite.contents().name().withPrefix("textures/particle/").withSuffix(".png");
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }
}

