/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.DirectionParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EggSplatParticle
extends FlatPlaneParticle {
    private final Direction direction;

    protected EggSplatParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, Direction direction) {
        super(level, x, y, z);
        this.direction = direction;
        this.rotation = direction.getRotation().rotateX((float)Math.PI);
        this.pickSprite(sprites);
        this.lifetime = 120;
        this.quadSize = 0.2f;
        if (direction.getAxis().isVertical()) {
            this.rotation.rotateY((float)(90 * this.random.nextInt(3)) * ((float)Math.PI / 180));
        }
    }

    public void tick() {
        super.tick();
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.getBlockState(pos.relative(this.direction)).isAir()) {
            this.remove();
            return;
        }
        if (Util.isSolidOrNotEmpty((Level)this.level, pos)) {
            this.remove();
            return;
        }
        int i = this.lifetime / 3 * 2;
        if (this.age == i && this.direction.getAxis().isHorizontal()) {
            this.gravity = 0.05f;
        }
        if (this.age >= i) {
            this.alpha = Mth.clamp((float)(this.alpha - 0.0125f), (float)0.0f, (float)1.0f);
        }
    }

    @Override
    protected void renderVertex(VertexConsumer buffer, Quaternionf rotation, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        Vector3f vector3f = new Vector3f(xOffset, 0.0f, yOffset).rotate((Quaternionfc)rotation).mul(quadSize).add(x, y, z);
        buffer.addVertex(vector3f.x(), vector3f.y(), vector3f.z()).setUv(u, v).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(packedLight);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<DirectionParticleOptions>
    {
        public Particle createParticle(DirectionParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new EggSplatParticle(level, x, y, z, this.sprites, options.direction());
        }
    }
}

