/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.init;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModSounds;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ModAnimalFedEffectSettings {
    private static final Map<EntityType<?>, Settings> REGISTERED = new HashMap();
    public static final Settings DEFAULT_VALUE = new Settings(Vec3.ZERO, null, stack -> stack);

    public static void init() {
        REGISTERED.clear();
        if (((Float)ModConfigs.ENTITIES.animalFeedingSoundVolume.get()).floatValue() == 0.0f && !ModConfigs.ENTITIES.animalFeedingParticles) {
            return;
        }
        ModAnimalFedEffectSettings.register(EntityType.COW, ModSounds.COW_EAT);
        ModAnimalFedEffectSettings.register(EntityType.MOOSHROOM, SoundEvents.MOOSHROOM_EAT);
        ModAnimalFedEffectSettings.register(EntityType.CHICKEN, 0.3, -0.7, ModSounds.CHICKEN_EAT);
        ModAnimalFedEffectSettings.register(EntityType.CAT, 0.0, -0.4, SoundEvents.CAT_EAT);
        ModAnimalFedEffectSettings.register(EntityType.OCELOT, 0.0, -0.3, ModSounds.OCELOT_EAT);
        ModAnimalFedEffectSettings.register(EntityType.PANDA, -0.35, 0.3, SoundEvents.PANDA_EAT);
        ModAnimalFedEffectSettings.register(EntityType.SHEEP, 0.0, -0.2, ModSounds.SHEEP_EAT);
        ModAnimalFedEffectSettings.register(EntityType.PARROT, 0.2, -0.9, SoundEvents.PARROT_EAT);
        ModAnimalFedEffectSettings.register(EntityType.AXOLOTL, new Vec3(0.0, 0.0, -0.4), ModSounds.AXOLOTL_EAT, stack -> stack.is(Items.TROPICAL_FISH_BUCKET) ? new ItemStack((ItemLike)Items.TROPICAL_FISH) : stack);
        ModAnimalFedEffectSettings.register(EntityType.CAMEL, 1.0, 0.6);
        ModAnimalFedEffectSettings.register(EntityType.BEE, 0.0, -0.7, ModSounds.BEE_EAT);
        ModAnimalFedEffectSettings.register(EntityType.FROG, 0.0, -0.7, SoundEvents.FROG_EAT);
        ModAnimalFedEffectSettings.register(EntityType.DOLPHIN, 0.0, -0.2, SoundEvents.DOLPHIN_EAT);
        ModAnimalFedEffectSettings.register(EntityType.TADPOLE, 0.0, -0.9, ModSounds.TADPOLE_EAT);
        ModAnimalFedEffectSettings.register(EntityType.FOX, 0.0, -0.6);
        ModAnimalFedEffectSettings.register(EntityType.LLAMA, 0.4, -0.1);
        ModAnimalFedEffectSettings.register(EntityType.TRADER_LLAMA, 0.4, -0.1);
        ModAnimalFedEffectSettings.register(EntityType.RABBIT, 0.0, -0.8, ModSounds.RABBIT_EAT);
        ModAnimalFedEffectSettings.register(EntityType.SNIFFER, 0.0, 1.5);
        ModAnimalFedEffectSettings.register(EntityType.MULE, 0.0, 0.2);
        ModAnimalFedEffectSettings.register(EntityType.DONKEY, 0.0, 0.2);
        ModAnimalFedEffectSettings.register(EntityType.HORSE, 0.2, 0.4);
        ModAnimalFedEffectSettings.register(EntityType.STRIDER, 0.0, -0.6);
        ModAnimalFedEffectSettings.register(EntityType.ARMADILLO, 0.0, -0.4);
        ModAnimalFedEffectSettings.register(EntityType.WOLF, 0.0, -0.3);
        ModAnimalFedEffectSettings.register(EntityType.TURTLE, ModSounds.TURTLE_EAT);
        ModAnimalFedEffectSettings.register(EntityType.HOGLIN, ModSounds.HOGLIN_EAT);
    }

    public static void register(EntityType<?> type, double y, double z) {
        ModAnimalFedEffectSettings.register(type, y, z, (Supplier<SoundEvent>)null);
    }

    public static void register(EntityType<?> type, double y, double z, @Nullable SoundEvent sound) {
        ModAnimalFedEffectSettings.register(type, y, z, () -> sound);
    }

    public static void register(EntityType<?> type, double y, double z, @Nullable Supplier<SoundEvent> sound) {
        ModAnimalFedEffectSettings.register(type, new Vec3(0.0, y, z), sound);
    }

    public static void register(EntityType<?> type, @Nullable SoundEvent sound) {
        ModAnimalFedEffectSettings.register(type, Vec3.ZERO, () -> sound);
    }

    public static void register(EntityType<?> type, @Nullable Supplier<SoundEvent> sound) {
        ModAnimalFedEffectSettings.register(type, Vec3.ZERO, sound);
    }

    public static void register(EntityType<?> type, Vec3 offset, @Nullable Supplier<SoundEvent> sound) {
        ModAnimalFedEffectSettings.register(type, offset, sound, stack -> stack);
    }

    public static void register(EntityType<?> type, Vec3 offset, @Nullable Supplier<SoundEvent> sound, UnaryOperator<ItemStack> stackReplacer) {
        if (REGISTERED.put(type, new Settings(offset, sound, stackReplacer)) != null) {
            SubtleEffects.LOGGER.error("Attempted to register multiple feeding effect overrides to entity: \"{}\"", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(type));
        }
    }

    public static Settings getSetting(EntityType<?> type) {
        return REGISTERED.getOrDefault(type, DEFAULT_VALUE);
    }

    public record Settings(Vec3 offset, @Nullable Supplier<SoundEvent> sound, UnaryOperator<ItemStack> stackReplacer) {
    }
}

