/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import einstein.subtle_effects.client.model.entity.EinsteinSolarSystemModel;
import einstein.subtle_effects.client.model.entity.PartyHatModel;
import einstein.subtle_effects.client.model.particle.SplashParticleModel;
import einstein.subtle_effects.client.renderer.entity.EinsteinSolarSystemLayer;
import einstein.subtle_effects.client.renderer.entity.PartyHatLayer;
import einstein.subtle_effects.init.ModAnimalFedEffectSettings;
import einstein.subtle_effects.init.ModBlockTickers;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModDamageListeners;
import einstein.subtle_effects.init.ModEntityTickers;
import einstein.subtle_effects.init.ModParticleRenderTypes;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModPayloads;
import einstein.subtle_effects.init.ModRenderTypes;
import einstein.subtle_effects.init.ModSpriteSets;
import einstein.subtle_effects.mixin.client.particle.ParticleEngineAccessor;
import einstein.subtle_effects.ticking.GeyserManager;
import einstein.subtle_effects.ticking.biome_particles.BiomeParticleManager;
import einstein.subtle_effects.ticking.tickers.ChestBlockEntityTicker;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.ticking.tickers.WaterfallTicker;
import einstein.subtle_effects.ticking.tickers.entity.EntityTickerManager;
import einstein.subtle_effects.util.FrustumGetter;
import einstein.subtle_effects.util.ParticleAccessor;
import einstein.subtle_effects.util.Util;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class SubtleEffectsClient {
    private static boolean HAS_CLEARED = false;
    private static boolean DISPLAY_PARTICLE_COUNT = false;
    private static boolean HAS_DISPLAYED_BIRTHDAY_NOTIFICATION = false;
    private static boolean DISPLAY_PARTICLE_BOUNDING_BOXES = false;
    private static Level LEVEL;

    public static void clientSetup() {
        ModConfigs.init();
        ModRenderTypes.init();
        ModParticleRenderTypes.init();
        ModPayloads.initClientHandlers();
        ModEntityTickers.init();
        ModBlockTickers.init();
        BiomeParticleManager.init();
        ModDamageListeners.init();
        ModParticles.init();
        ModSpriteSets.init();
        ModAnimalFedEffectSettings.init();
    }

    public static void clientTick(Minecraft minecraft, Level level) {
        LocalPlayer player = minecraft.player;
        if (level == null || player == null || LEVEL != level) {
            LEVEL = level;
            if (!HAS_CLEARED) {
                SubtleEffectsClient.clear(level);
                BiomeParticleManager.clear();
                HAS_CLEARED = true;
            }
            return;
        }
        if (minecraft.isPaused() || level.tickRateManager().isFrozen()) {
            return;
        }
        if (!HAS_DISPLAYED_BIRTHDAY_NOTIFICATION && ModConfigs.GENERAL.enableEasterEggs && PartyHatLayer.isModBirthday(true)) {
            long years = ChronoUnit.YEARS.between(LocalDate.of(2024, Month.OCTOBER, 3), LocalDate.now());
            SubtleEffectsClient.sendSystemMsg((Player)player, (Component)Component.empty().append((Component)Component.translatable((String)"chat.subtle_effects.prefix").withStyle(style -> style.withColor(ChatFormatting.BLUE))).append(CommonComponents.SPACE).append((Component)Component.translatable((String)"chat.subtle_effects.anniversary.message", (Object[])new Object[]{Util.getOrdinal(years)})));
            HAS_DISPLAYED_BIRTHDAY_NOTIFICATION = true;
        }
        if (DISPLAY_PARTICLE_COUNT) {
            player.displayClientMessage((Component)Component.translatable((String)"ui.subtle_effects.hud.particle_count", (Object[])new Object[]{minecraft.particleEngine.countParticles()}), true);
        }
        ProfilerFiller profiler = minecraft.getProfiler();
        profiler.push("subtle_effects");
        profiler.push("biome_particles");
        BiomeParticleManager.tickBiomeParticles(level, (Player)player);
        profiler.pop();
        profiler.push("tickers");
        TickerManager.tick();
        profiler.pop();
        HAS_CLEARED = false;
        profiler.pop();
    }

    public static Map<ModelLayerLocation, Supplier<LayerDefinition>> registerModelLayers() {
        HashMap<ModelLayerLocation, Supplier<LayerDefinition>> layers = new HashMap<ModelLayerLocation, Supplier<LayerDefinition>>();
        layers.put(EinsteinSolarSystemModel.MODEL_LAYER, EinsteinSolarSystemModel::createLayer);
        layers.put(PartyHatModel.MODEL_LAYER, PartyHatModel::createLayer);
        layers.put(SplashParticleModel.MODEL_LAYER, SplashParticleModel::createLayer);
        return layers;
    }

    public static List<RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>> registerPlayerRenderLayers(PlayerRenderer renderer, EntityRendererProvider.Context context) {
        ArrayList<RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>> renderLayers = new ArrayList<RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>>();
        renderLayers.add(new EinsteinSolarSystemLayer(renderer, context));
        if (PartyHatLayer.isModBirthday(false)) {
            renderLayers.add(new PartyHatLayer(renderer, context));
        }
        return renderLayers;
    }

    public static <T extends SharedSuggestionProvider> void registerClientCommands(CommandDispatcher<T> dispatcher, CommandBuildContext buildContext) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        LiteralArgumentBuilder particlesClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$1(minecraft, (Player)player, arg_0));
        RequiredArgumentBuilder particlesCountEnabled = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$2((Player)player, arg_0));
        LiteralArgumentBuilder particlesCount = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"count").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$3((Player)player, arg_0))).then((ArgumentBuilder)particlesCountEnabled);
        RequiredArgumentBuilder particlesBoundingBoxesEnabled = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$4((Player)player, arg_0));
        LiteralArgumentBuilder particlesBoundingBoxes = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"display_bounding_boxes").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$5((Player)player, arg_0))).then((ArgumentBuilder)particlesBoundingBoxesEnabled);
        LiteralArgumentBuilder particles = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"particles").then((ArgumentBuilder)particlesClear)).then((ArgumentBuilder)particlesCount)).then((ArgumentBuilder)particlesBoundingBoxes);
        LiteralArgumentBuilder tickersClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$6(minecraft, (Player)player, arg_0));
        LiteralArgumentBuilder tickers = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"tickers").then((ArgumentBuilder)tickersClear);
        LiteralArgumentBuilder subtleEffects = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"subtle_effects").then((ArgumentBuilder)particles)).then((ArgumentBuilder)tickers);
        LiteralCommandNode subtleEffectsNode = dispatcher.register(subtleEffects);
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"se").redirect((CommandNode)subtleEffectsNode));
    }

    private static int toggleParticleCount(Player player, boolean enabled) {
        DISPLAY_PARTICLE_COUNT = enabled;
        String enabledString = enabled ? "enable" : "disable";
        SubtleEffectsClient.sendSystemMsg(player, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.count." + enabledString + ".success"));
        return 1;
    }

    private static int toggleParticleBoundingBoxes(Player player, boolean enabled) {
        DISPLAY_PARTICLE_BOUNDING_BOXES = enabled;
        String enabledString = enabled ? "enable" : "disable";
        SubtleEffectsClient.sendSystemMsg(player, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.display_bounding_boxes." + enabledString + ".success"));
        return 1;
    }

    private static MutableComponent getMsgTranslation(String string) {
        return Component.translatable((String)("commands.subtle_effects." + string));
    }

    private static void sendSystemMsg(Player player, Component component) {
        if (player != null) {
            player.sendSystemMessage(component);
        }
    }

    public static void clear(@Nullable Level level) {
        TickerManager.clear();
        EntityTickerManager.clear(level);
        GeyserManager.ACTIVE_GEYSERS.clear();
        GeyserManager.INACTIVE_GEYSERS.clear();
        WaterfallTicker.WATERFALLS.clear();
        ChestBlockEntityTicker.clear();
    }

    public static void renderParticleBoundingBoxes(PoseStack poseStack, Camera camera) {
        if (DISPLAY_PARTICLE_BOUNDING_BOXES) {
            poseStack.pushPose();
            Minecraft minecraft = Minecraft.getInstance();
            MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
            VertexConsumer consumer = bufferSource.getBuffer(RenderType.lines());
            Vec3 cameraPos = camera.getPosition();
            Frustum frustum = ((FrustumGetter)minecraft.levelRenderer).subtleEffects$getCullingFrustum();
            float partialTicks = Util.getPartialTicks();
            ((ParticleEngineAccessor)minecraft.particleEngine).getParticles().forEach((renderType, particles) -> {
                if (particles == null || particles.isEmpty()) {
                    return;
                }
                Vector3f renderTypeColor = Vec3.fromRGB24((int)FastColor.ARGB32.color((int)255, (int)renderType.toString().hashCode())).toVector3f();
                particles.forEach(particle -> {
                    AABB aabb = particle.getBoundingBox();
                    if (frustum.isVisible(aabb)) {
                        poseStack.pushPose();
                        ParticleAccessor accessor = (ParticleAccessor)particle;
                        double x = Mth.lerp((double)partialTicks, (double)accessor.getOldX(), (double)accessor.getX()) - cameraPos.x();
                        double y = Mth.lerp((double)partialTicks, (double)accessor.getOldY(), (double)accessor.getY()) - cameraPos.y();
                        double z = Mth.lerp((double)partialTicks, (double)accessor.getOldZ(), (double)accessor.getZ()) - cameraPos.z();
                        poseStack.translate(x, y, z);
                        aabb = aabb.move(-accessor.getX(), -accessor.getY(), -accessor.getZ());
                        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)aabb, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        AABB renderTypeAABB = new AABB(aabb.minX, aabb.maxY - 0.02, aabb.minZ, aabb.maxX, aabb.maxY + 0.02, aabb.maxZ);
                        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)renderTypeAABB, (float)renderTypeColor.x(), (float)renderTypeColor.y(), (float)renderTypeColor.z(), (float)1.0f);
                        poseStack.popPose();
                    }
                });
            });
            bufferSource.endBatch(RenderType.lines());
            poseStack.popPose();
        }
    }

    private static /* synthetic */ int lambda$registerClientCommands$6(Minecraft minecraft, Player player, CommandContext context) throws CommandSyntaxException {
        SubtleEffectsClient.clear((Level)minecraft.level);
        SubtleEffectsClient.sendSystemMsg(player, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.tickers.clear.success"));
        return 1;
    }

    private static /* synthetic */ int lambda$registerClientCommands$5(Player player, CommandContext context) throws CommandSyntaxException {
        return SubtleEffectsClient.toggleParticleBoundingBoxes(player, true);
    }

    private static /* synthetic */ int lambda$registerClientCommands$4(Player player, CommandContext context) throws CommandSyntaxException {
        return SubtleEffectsClient.toggleParticleBoundingBoxes(player, BoolArgumentType.getBool((CommandContext)context, (String)"enabled"));
    }

    private static /* synthetic */ int lambda$registerClientCommands$3(Player player, CommandContext context) throws CommandSyntaxException {
        return SubtleEffectsClient.toggleParticleCount(player, true);
    }

    private static /* synthetic */ int lambda$registerClientCommands$2(Player player, CommandContext context) throws CommandSyntaxException {
        return SubtleEffectsClient.toggleParticleCount(player, BoolArgumentType.getBool((CommandContext)context, (String)"enabled"));
    }

    private static /* synthetic */ int lambda$registerClientCommands$1(Minecraft minecraft, Player player, CommandContext context) throws CommandSyntaxException {
        minecraft.particleEngine.clearParticles();
        SubtleEffectsClient.sendSystemMsg(player, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.clear.success"));
        return 1;
    }
}

