/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.util;

import com.mrcrayfish.backpacked.Config;
import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PickpocketUtil {
    public static Vec3 getEntityPos(Entity entity, float partialTick) {
        double x = Mth.lerp((double)partialTick, (double)entity.xo, (double)entity.getX());
        double y = Mth.lerp((double)partialTick, (double)entity.yo, (double)entity.getY());
        double z = Mth.lerp((double)partialTick, (double)entity.zo, (double)entity.getZ());
        return new Vec3(x, y, z);
    }

    public static AABB getBackpackBox(LivingEntity entity, float partialTick) {
        AABB backpackBox = new AABB(-0.25, 0.0, -0.25, 0.25, 0.5625, 0.25);
        backpackBox = backpackBox.move(PickpocketUtil.getEntityPos((Entity)entity, partialTick));
        backpackBox = backpackBox.move(0.0, entity.getPose() != Pose.SWIMMING ? 0.875 : 0.3125, 0.0);
        if (entity.getPose() == Pose.CROUCHING) {
            backpackBox = backpackBox.move(0.0, -0.1875, 0.0);
        }
        float bodyRotation = Mth.lerp((float)partialTick, (float)entity.yBodyRotO, (float)entity.yBodyRot);
        backpackBox = backpackBox.move(Vec3.directionFromRotation((float)0.0f, (float)(bodyRotation + 180.0f)).scale(entity.getPose() != Pose.SWIMMING ? 0.3125 : -0.125));
        return backpackBox;
    }

    public static boolean canPickpocketEntity(LivingEntity targetEntity, Player thiefPlayer) {
        return PickpocketUtil.canPickpocketEntity(targetEntity, thiefPlayer, (Double)Config.SERVER.pickpocketing.maxReachDistance.get());
    }

    public static boolean canPickpocketEntity(LivingEntity targetEntity, Player thiefPlayer, double range) {
        return PickpocketUtil.inRangeOfBackpack(targetEntity, thiefPlayer) && PickpocketUtil.inReachOfBackpack(targetEntity, thiefPlayer, range);
    }

    public static boolean inRangeOfBackpack(LivingEntity livingEntity, Player thiefPlayer) {
        if (livingEntity.getPose() == Pose.SWIMMING) {
            return true;
        }
        Vec3 between = PickpocketUtil.getEntityPos((Entity)thiefPlayer, 1.0f).subtract(PickpocketUtil.getEntityPos((Entity)livingEntity, 1.0f));
        float angle = (float)Math.toDegrees(Math.atan2(between.z, between.x)) - 90.0f;
        float difference = Mth.degreesDifferenceAbs((float)(livingEntity.yBodyRot + 180.0f), (float)angle);
        return (double)difference <= (Double)Config.SERVER.pickpocketing.maxRangeAngle.get();
    }

    public static boolean inReachOfBackpack(LivingEntity targetPlayer, Player thiefPlayer, double reachDistance) {
        Vec3 pos = PickpocketUtil.getEntityPos((Entity)targetPlayer, 1.0f);
        pos = pos.add(Vec3.directionFromRotation((float)0.0f, (float)(targetPlayer.yBodyRot + 180.0f)).scale(targetPlayer.getPose() != Pose.SWIMMING ? 0.3125 : -0.125));
        return pos.distanceTo(PickpocketUtil.getEntityPos((Entity)thiefPlayer, 1.0f)) <= reachDistance;
    }

    public static boolean canSeeBackpack(LivingEntity targetEntity, Player thiefPlayer) {
        Vec3 end;
        Vec3 start;
        if ((double)targetEntity.distanceTo((Entity)thiefPlayer) > 4.0) {
            return false;
        }
        AABB backpackBox = PickpocketUtil.getBackpackBox(targetEntity, 1.0f);
        Optional hitPos = backpackBox.clip(start = thiefPlayer.getEyePosition(1.0f), end = thiefPlayer.getViewVector(1.0f).scale(((Double)Config.SERVER.pickpocketing.maxReachDistance.get()).doubleValue()).add(start));
        if (hitPos.isEmpty()) {
            return false;
        }
        BlockHitResult result = thiefPlayer.level().clip(new ClipContext(start, (Vec3)hitPos.get(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)thiefPlayer));
        if (result.getType() == HitResult.Type.MISS) {
            return true;
        }
        return start.distanceTo((Vec3)hitPos.get()) < start.distanceTo(result.getLocation());
    }
}

