/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.integration;

import com.mrcrayfish.backpacked.Config;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.stream.StreamSupport;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import org.jetbrains.annotations.Nullable;

public class BackpackAccessory
implements Accessory {
    @Nullable
    public SoundEventData getEquipSound(ItemStack stack, SlotReference reference) {
        return new SoundEventData(SoundEvents.ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
    }

    public boolean canEquipFromUse(ItemStack stack) {
        return true;
    }

    public boolean canUnequip(ItemStack stack, SlotReference reference) {
        if (!((Boolean)Config.SERVER.backpack.lockIntoSlot.get()).booleanValue()) {
            return true;
        }
        ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        return contents == null || StreamSupport.stream(contents.nonEmptyItems().spliterator(), false).allMatch(ItemStack::isEmpty);
    }

    public DropRule getDropRule(ItemStack stack, SlotReference reference, DamageSource source) {
        return (Boolean)Config.SERVER.backpack.keepOnDeath.get() != false ? DropRule.KEEP : DropRule.DEFAULT;
    }
}

