/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.BackpackedCodecs;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CraftItemChallenge
extends Challenge {
    public static final ChallengeSerializer<CraftItemChallenge> SERIALIZER = new ChallengeSerializer(ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"craft_item"), RecordCodecBuilder.mapCodec(builder -> builder.group((App)ProgressFormatter.CODEC.fieldOf("formatter").orElse((Object)ProgressFormatter.CRAFT_X_OF_X).forGetter(challenge -> challenge.formatter), (App)CraftedItemPredicate.CODEC.optionalFieldOf("crafted_item").forGetter(challenge -> challenge.predicate), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("count", (Object)1).forGetter(challenge -> challenge.count)).apply((Applicative)builder, CraftItemChallenge::new)));
    private final ProgressFormatter formatter;
    private final Optional<CraftedItemPredicate> predicate;
    private final int count;

    public CraftItemChallenge(ProgressFormatter formatter, Optional<CraftedItemPredicate> predicate, int count) {
        this.formatter = formatter;
        this.predicate = predicate;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(ResourceLocation backpackId) {
        return new Tracker(this.formatter, this.predicate, this.count);
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<CraftedItemPredicate> predicate;

        public Tracker(ProgressFormatter formatter, Optional<CraftedItemPredicate> predicate, int maxCount) {
            super(maxCount, formatter);
            this.predicate = predicate;
        }

        public static void registerEvent() {
            PlayerEvents.CRAFT_ITEM.register((IFrameworkEvent)((IPlayerEvent.CraftItem)(player, stack, inventory) -> {
                if (player.level().isClientSide()) {
                    return;
                }
                UnlockManager.getTrackers(player, Tracker.class).forEach(tracker -> {
                    if (tracker.isComplete()) {
                        return;
                    }
                    if (tracker.predicate.map(p -> p.test(stack)).orElse(true).booleanValue()) {
                        tracker.increment(stack.getCount(), (ServerPlayer)player);
                    }
                });
            }));
        }
    }

    public record CraftedItemPredicate(Optional<Set<String>> modIds, Optional<TagKey<Item>> tag, Optional<HolderSet<Item>> items) {
        public static final Codec<CraftedItemPredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BackpackedCodecs.STRING_SET.optionalFieldOf("namespace").forGetter(o -> o.modIds), (App)TagKey.codec((ResourceKey)Registries.ITEM).optionalFieldOf("tag").forGetter(CraftedItemPredicate::tag), (App)BackpackedCodecs.ITEMS.optionalFieldOf("items").forGetter(CraftedItemPredicate::items)).apply((Applicative)builder, CraftedItemPredicate::new));

        public boolean test(ItemStack stack) {
            if (this.modIds.isPresent()) {
                ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                if (this.modIds.get().contains(key.getNamespace())) {
                    return true;
                }
            }
            if (this.tag.isPresent() && stack.is(this.tag.get())) {
                return true;
            }
            return this.items.isPresent() && this.items.get().contains(stack.getItemHolder());
        }
    }
}

