/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncBackpacks;
import com.mrcrayfish.backpacked.network.message.MessageUnlockBackpack;
import com.mrcrayfish.framework.api.config.event.FrameworkConfigEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public final class BackpackManager {
    private static final ResourceLocation FALLBACK_MODEL = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"standard");
    private static ResourceLocation defaultCosmetic;
    private static BackpackManager instance;
    private Map<ResourceLocation, Backpack> loadedBackpacks = new HashMap<ResourceLocation, Backpack>();

    public static BackpackManager instance() {
        if (instance == null) {
            instance = new BackpackManager();
        }
        return instance;
    }

    private BackpackManager() {
        FrameworkConfigEvents.LOAD.register((IFrameworkEvent)((FrameworkConfigEvents.Load)object -> {
            if (object == Config.SERVER) {
                BackpackManager.updateDefaultCosmetic();
            }
        }));
        FrameworkConfigEvents.RELOAD.register((IFrameworkEvent)((FrameworkConfigEvents.Reload)object -> {
            if (object == Config.SERVER) {
                BackpackManager.updateDefaultCosmetic();
            }
        }));
    }

    public void updateBackpacks(Map<ResourceLocation, Backpack> map) {
        this.loadedBackpacks = map;
    }

    @Nullable
    public Backpack getBackpack(ResourceLocation id) {
        return this.loadedBackpacks.get(id);
    }

    public List<Backpack> getBackpacks() {
        return ImmutableList.copyOf(this.loadedBackpacks.values());
    }

    public void unlockBackpack(ServerPlayer player, ResourceLocation id) {
        if (((Boolean)Config.SERVER.backpack.unlockAllCosmetics.get()).booleanValue()) {
            return;
        }
        if (!this.loadedBackpacks.containsKey(id)) {
            return;
        }
        UnlockManager.getTracker((Player)player).ifPresent(impl -> {
            if (impl.unlockBackpack(id)) {
                Network.getPlay().sendToPlayer(() -> player, (Object)new MessageUnlockBackpack(id));
            }
        });
    }

    public MessageSyncBackpacks getSyncMessage() {
        return new MessageSyncBackpacks(this.getBackpacks());
    }

    private static void updateDefaultCosmetic() {
        defaultCosmetic = ResourceLocation.tryParse((String)((String)Config.SERVER.backpack.defaultCosmetic.get()));
    }

    @Nullable
    public static ResourceLocation getDefaultCosmetic() {
        return defaultCosmetic;
    }

    public static ResourceLocation getDefaultOrFallbackCosmetic() {
        return defaultCosmetic != null ? defaultCosmetic : FALLBACK_MODEL;
    }
}

