/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.backpacked.client.ClientRegistry;
import com.mrcrayfish.backpacked.client.backpack.ClientBackpack;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.common.backpack.ModelMeta;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.data.pickpocket.TraderPickpocketing;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class VillagerBackpackLayer<T extends AbstractVillager, M extends VillagerModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation WANDERING_BACKPACK = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"wandering_bag");
    private final ItemStack displayStack = new ItemStack((ItemLike)ModItems.BACKPACK.get());
    private final ItemRenderer itemRenderer;

    public VillagerBackpackLayer(RenderLayerParent<T, M> renderer, ItemRenderer itemRenderer) {
        super(renderer);
        this.itemRenderer = itemRenderer;
    }

    public void render(PoseStack pose, MultiBufferSource source, int light, T villager, float p_225628_5_, float p_225628_6_, float partialTick, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        TraderPickpocketing.get(villager).ifPresent(data -> {
            if (!data.isBackpackEquipped()) {
                return;
            }
            if (villager.isInvisible()) {
                return;
            }
            ClientBackpack backpack = ClientRegistry.instance().getBackpack(WANDERING_BACKPACK);
            if (backpack == null) {
                return;
            }
            pose.pushPose();
            pose.mulPose(Axis.YP.rotationDegrees(180.0f));
            pose.scale(1.0f, -1.0f, -1.0f);
            pose.translate(0.0, -0.06, 0.21875);
            ModelMeta meta = ClientRegistry.instance().getModelMeta(backpack);
            meta.renderer().ifPresentOrElse(renderer -> {
                pose.pushPose();
                BackpackRenderContext context = new BackpackRenderContext(pose, source, light, this.displayStack, backpack, (LivingEntity)villager, partialTick, villager.tickCount, model -> this.itemRenderer.render(this.displayStack, ItemDisplayContext.NONE, false, pose, source, light, OverlayTexture.NO_OVERLAY, model));
                renderer.forEach(function -> function.apply(context));
                pose.popPose();
            }, () -> {
                BakedModel model = this.itemRenderer.getItemModelShaper().getModelManager().getModel(backpack.getBaseModel());
                this.itemRenderer.render(this.displayStack, ItemDisplayContext.NONE, false, pose, source, light, OverlayTexture.NO_OVERLAY, model);
            });
            pose.popPose();
        });
    }

    private ModelPart getBody(VillagerModel<T> model) {
        return model.root().getChild("body");
    }
}

