/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createendertransmission.blocks;

import com.forsteri.createendertransmission.blocks.MatterTransmitterNetwork;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class MatterWorldSavedData
extends SavedData {
    @NotNull
    public CompoundTag save(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        for (MatterTransmitterNetwork network : MatterTransmitterNetwork.values()) {
            CompoundTag networkTag = new CompoundTag();
            List<Map<String, INBTSerializable<CompoundTag>>> channels = network.channels;
            pTag.put(network.name().toLowerCase(), (Tag)networkTag);
            for (int i = 0; i < 10; ++i) {
                Map<String, INBTSerializable<CompoundTag>> channel = channels.get(i);
                CompoundTag channelTag = new CompoundTag();
                networkTag.put(String.valueOf(i), (Tag)channelTag);
                for (Map.Entry<String, INBTSerializable<CompoundTag>> entry : channel.entrySet()) {
                    channelTag.put(entry.getKey(), entry.getValue().serializeNBT(registries));
                }
            }
        }
        return pTag;
    }

    private static MatterWorldSavedData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        for (MatterTransmitterNetwork network : MatterTransmitterNetwork.values()) {
            CompoundTag networkTag = tag.getCompound(network.name().toLowerCase());
            List<Map<String, INBTSerializable<CompoundTag>>> channels = network.channels;
            for (int i = 0; i < 10; ++i) {
                Map<String, INBTSerializable<CompoundTag>> channel = channels.get(i);
                CompoundTag channelTag = networkTag.getCompound(String.valueOf(i));
                channelTag.getAllKeys().forEach(key -> {
                    Tag patt0$temp = channelTag.get(key);
                    if (!(patt0$temp instanceof CompoundTag)) {
                        return;
                    }
                    CompoundTag compoundTag = (CompoundTag)patt0$temp;
                    if (!channel.containsKey(key)) {
                        channel.put((String)key, network.defaultInv.get());
                    }
                    ((INBTSerializable)channel.get(key)).deserializeNBT(lookupProvider, (Tag)compoundTag);
                });
            }
        }
        return new MatterWorldSavedData();
    }

    public static MatterWorldSavedData load(MinecraftServer server) {
        return (MatterWorldSavedData)server.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(MatterWorldSavedData::new, MatterWorldSavedData::load), "ender_transmission_matter_transmission");
    }
}

