/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.disccord.client.audio;

import com.mrbysco.disccord.DiscCordMod;
import com.mrbysco.disccord.client.audio.PathTools;
import com.mrbysco.disccord.config.DiscCordConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.commons.lang3.SystemUtils;

public class FFmpeg {
    static String ffmpegPath = null;

    static void checkForExecutable() throws IOException {
        Optional<String> pathExecutable = PathTools.traversePath("ffmpeg");
        if (!pathExecutable.isEmpty()) {
            ffmpegPath = pathExecutable.get().toString();
            return;
        }
        File FFmpegDirectory = FMLPaths.CONFIGDIR.get().resolve("disccord/ffmpeg/").toAbsolutePath().toFile();
        if (!FFmpegDirectory.exists() && !FFmpegDirectory.mkdirs()) {
            DiscCordMod.LOGGER.error("Failed to create the 'disccord/ffmpeg' directory");
            return;
        }
        String fileName = SystemUtils.IS_OS_WINDOWS ? "ffmpeg.exe" : "ffmpeg";
        File ffmpegFile = FFmpegDirectory.toPath().resolve(fileName).toFile();
        Minecraft mc = Minecraft.getInstance();
        if (!ffmpegFile.exists()) {
            if (((Boolean)DiscCordConfig.CLIENT.downloadFFmpeg.get()).booleanValue()) {
                File zipFile = FFmpegDirectory.toPath().resolve("ffmpeg.zip").toFile();
                InputStream inputStream = null;
                if (!FFmpegDirectory.toPath().resolve("ffmpeg.zip").toFile().exists()) {
                    if (SystemUtils.IS_OS_MAC) {
                        inputStream = new URL("https://evermeet.cx/ffmpeg/ffmpeg-6.1.zip").openStream();
                    } else if (SystemUtils.IS_OS_WINDOWS) {
                        inputStream = new URL("https://www.gyan.dev/ffmpeg/builds/ffmpeg-release-essentials.zip").openStream();
                    } else if (SystemUtils.IS_OS_LINUX) {
                        DiscCordMod.LOGGER.error("Automatic Linux ffmpeg install is not supported");
                    }
                }
                if (inputStream == null) {
                    DiscCordMod.LOGGER.error("Failed to download ffmpeg");
                    return;
                }
                Files.copy(inputStream, FFmpegDirectory.toPath().resolve("ffmpeg.zip"), StandardCopyOption.REPLACE_EXISTING);
                if (!zipFile.exists()) {
                    return;
                }
                ZipInputStream zipInput = new ZipInputStream(new FileInputStream(zipFile));
                ZipEntry zipEntry = zipInput.getNextEntry();
                while (zipEntry != null) {
                    if (zipEntry.getName().endsWith("ffmpeg.exe") || zipEntry.getName().endsWith("ffmpeg")) {
                        Path outPath = FFmpegDirectory.toPath().resolve(fileName);
                        Files.copy(zipInput, outPath, StandardCopyOption.REPLACE_EXISTING);
                        ffmpegPath = outPath.toString();
                        outPath.toFile().setExecutable(true);
                    }
                    zipEntry = zipInput.getNextEntry();
                }
                if (!zipFile.delete()) {
                    DiscCordMod.LOGGER.error("Failed to delete the {} file", (Object)zipFile.getName());
                }
            } else {
                if (mc.player != null) {
                    mc.player.sendSystemMessage((Component)Component.translatable((String)"disccord.ffmpeg.missing").withStyle(ChatFormatting.RED));
                }
                for (String message : FFmpeg.getMissingMessage()) {
                    DiscCordMod.LOGGER.error(message);
                }
            }
        } else if (SystemUtils.IS_OS_WINDOWS || ffmpegFile.canExecute()) {
            ffmpegPath = ffmpegFile.getAbsolutePath();
        } else {
            if (mc.player != null) {
                mc.player.sendSystemMessage((Component)Component.translatable((String)"disccord.executable.permission", (Object[])new Object[]{ffmpegFile.getName()}).withStyle(ChatFormatting.RED));
            }
            DiscCordMod.LOGGER.error("The '{}' executable isn't executeable, please make sure to add the executeable permission with chmod +x", (Object)ffmpegFile.getName());
        }
    }

    static void executeFFmpegCommand(String ... arguments) throws IOException, InterruptedException {
        Process resultProcess;
        if (ffmpegPath == null || !new File(ffmpegPath).canExecute()) {
            FFmpeg.checkForExecutable();
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(ffmpegPath);
        Collections.addAll(cmdList, arguments);
        DiscCordMod.LOGGER.debug("Executing '{}'", (Object)String.join((CharSequence)" ", cmdList));
        if (SystemUtils.IS_OS_LINUX) {
            String cmd = String.join((CharSequence)" ", cmdList);
            String[] cmds = new String[]{"/bin/sh", "-c", cmd};
            resultProcess = Runtime.getRuntime().exec(cmds);
        } else {
            resultProcess = Runtime.getRuntime().exec(cmdList.toArray(new String[0]));
        }
        int result = resultProcess.waitFor();
        if (result != 0) {
            throw new IOException("Process exited with error code " + result);
        }
    }

    static String[] getMissingMessage() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return new String[]{"ERROR: 'ffmpeg.exe' wasn't found in the 'config/disccord/ffmpeg' folder!", "Please visit one of the following URLs to download it:", " - https://www.gyan.dev/ffmpeg/builds/", " - https://github.com/BtbN/FFmpeg-Builds/releases", "", "Locate the 'bin/ffmpeg.exe' file in the .zip and place it in the 'config/disccord/ffmpeg' folder"};
        }
        if (SystemUtils.IS_OS_MAC) {
            return new String[]{"ERROR: 'ffmpeg' wasn't found in the 'config/disccord/ffmpeg' folder!", "Please visit one the following URL to download it:", " - https://ffmpeg.org/download.html#build-mac", "", "Locate the 'bin/ffmpeg' file in the .7x/.zip and place it in the 'config/disccord/ffmpeg' folder"};
        }
        if (SystemUtils.IS_OS_LINUX) {
            return new String[]{"ERROR: ffmpeg is not installed on this system!", "Please install ffmpeg", " - Debian: apt install ffmpeg", " - Ubuntu: apt install ffmpeg", " - Fedora: dnf install ffmpeg", " - Arch: pacman -S ffmpeg", "", "Alternatively, place the 'ffmpeg' executable in the ", "'config/disccord/ffmpeg' folder of this repository"};
        }
        return new String[0];
    }
}

