/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.disccord.client;

import com.mrbysco.disccord.client.audio.AudioHandlerClient;
import com.mrbysco.disccord.client.audio.FileSound;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ClientHandler {
    public static final Map<Vec3, FileSound> playingSounds = new HashMap<Vec3, FileSound>();
    public static final Map<UUID, FileSound> playingSoundsByUUID = new HashMap<UUID, FileSound>();

    public static void playRecord(Vec3 centerPos, String fileUrl, @NotNull UUID uuid) {
        FileSound currentSound;
        Minecraft mc = Minecraft.getInstance();
        FileSound fileSound = currentSound = !uuid.equals(Util.NIL_UUID) ? playingSoundsByUUID.get(uuid) : playingSounds.get(centerPos);
        if (currentSound != null) {
            mc.getSoundManager().stop((SoundInstance)currentSound);
            if (!uuid.equals(Util.NIL_UUID)) {
                playingSoundsByUUID.remove(uuid);
            } else {
                playingSounds.remove(centerPos);
            }
        }
        if (fileUrl.isEmpty()) {
            return;
        }
        AudioHandlerClient audioHandler = new AudioHandlerClient();
        if (!audioHandler.checkForAudioFile(fileUrl)) {
            mc.player.sendSystemMessage((Component)Component.translatable((String)"disccord.song.downloading"));
            audioHandler.downloadVideoAsOgg(fileUrl).thenApply(in -> {
                mc.player.sendSystemMessage((Component)Component.translatable((String)"disccord.song.succeed"));
                FileSound fileSound = new FileSound();
                fileSound.position = centerPos;
                fileSound.fileUrl = fileUrl;
                if (!uuid.equals(Util.NIL_UUID)) {
                    playingSoundsByUUID.put(uuid, fileSound);
                } else {
                    playingSounds.put(centerPos, fileSound);
                }
                mc.getSoundManager().play((SoundInstance)fileSound);
                return null;
            });
            return;
        }
        FileSound fileSound2 = new FileSound();
        fileSound2.position = centerPos;
        fileSound2.fileUrl = fileUrl;
        if (!uuid.equals(Util.NIL_UUID)) {
            playingSoundsByUUID.put(uuid, fileSound2);
        } else {
            playingSounds.put(centerPos, fileSound2);
        }
        mc.getSoundManager().play((SoundInstance)fileSound2);
    }
}

