/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.data.recipe;

import java.util.concurrent.CompletableFuture;
import mod.chiselsandbits.api.item.chisel.IChiselItem;
import mod.chiselsandbits.api.util.ParamValidator;
import mod.chiselsandbits.forge.data.recipe.AbstractRecipeGenerator;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChiselRecipeGenerator
extends AbstractRecipeGenerator {
    private final TagKey<Item> rodTag;
    private final TagKey<Item> ingredientTag;

    protected AbstractChiselRecipeGenerator(PackOutput generator, Item result, TagKey<Item> ingredientTag, CompletableFuture<HolderLookup.Provider> registries) {
        super(generator, (ItemLike)ParamValidator.isInstanceOf((Object)result, IChiselItem.class), registries);
        this.ingredientTag = ingredientTag;
        this.rodTag = Tags.Items.RODS_WOODEN;
    }

    protected AbstractChiselRecipeGenerator(PackOutput generator, Item result, TagKey<Item> rodTag, TagKey<Item> ingredientTag, CompletableFuture<HolderLookup.Provider> registries) {
        super(generator, (ItemLike)ParamValidator.isInstanceOf((Object)result, IChiselItem.class), registries);
        this.rodTag = rodTag;
        this.ingredientTag = ingredientTag;
    }

    protected void buildRecipes(@NotNull RecipeOutput writer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)this.getItemProvider()).pattern("st").pattern("  ").define(Character.valueOf('s'), this.rodTag).define(Character.valueOf('t'), this.ingredientTag).unlockedBy("has_rod", AbstractChiselRecipeGenerator.has(this.rodTag)).unlockedBy("has_ingredient", AbstractChiselRecipeGenerator.has(this.ingredientTag)).save(writer);
    }
}

