/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.data.lang;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import mod.chiselsandbits.keys.KeyBindingManager;
import net.minecraft.client.KeyMapping;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="chiselsandbits", bus=EventBusSubscriber.Bus.MOD)
public class KeyMapLangGenerator
implements DataProvider {
    private final PackOutput generator;

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().addProvider(true, (DataProvider)new KeyMapLangGenerator(event.getGenerator().getPackOutput()));
    }

    private KeyMapLangGenerator(PackOutput generator) {
        this.generator = generator;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        ArrayList<String> langKeys = new ArrayList<String>(KeyBindingManager.getInstance().getAllKeyBinds().stream().map(KeyMapping::getName).toList());
        Collections.sort(langKeys);
        JsonObject returnValue = new JsonObject();
        for (String langKey : langKeys) {
            returnValue.addProperty(langKey, "");
        }
        Path configLangFolder = this.generator.getOutputFolder().resolve("assets/chiselsandbits/lang/config/");
        Path langPath = configLangFolder.resolve("keymappings.json");
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)returnValue, (Path)langPath);
    }

    @NotNull
    public String getName() {
        return "Key Mapping generator";
    }
}

