/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.data.blockstate;

import com.communi.suggestu.scena.core.registries.deferred.IRegistryObject;
import mod.chiselsandbits.registrars.ModBlocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="chiselsandbits", bus=EventBusSubscriber.Bus.MOD)
public class ChiseledBlockBlockStateGenerator
extends BlockStateProvider
implements DataProvider {
    private static final ResourceLocation CHISELED_BLOCK_MODEL = ResourceLocation.fromNamespaceAndPath((String)"chiselsandbits", (String)"block/chiseled");

    public ChiseledBlockBlockStateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "chiselsandbits", exFileHelper);
    }

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().addProvider(true, (DataProvider)new ChiseledBlockBlockStateGenerator(event.getGenerator(), event.getExistingFileHelper()));
    }

    protected void registerStatesAndModels() {
        this.actOnBlock((Block)ModBlocks.CHISELED_BLOCK.get());
        ModBlocks.MATERIAL_TO_BLOCK_CONVERSIONS.values().stream().map(IRegistryObject::get).forEach(block -> this.getVariantBuilder((Block)block).forAllStates(blockState -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)"air"))).build()));
    }

    @NotNull
    public String getName() {
        return "Chiseled block blockstate generator";
    }

    public void actOnBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(blockState -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(CHISELED_BLOCK_MODEL)).build());
    }
}

