/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.sound.download;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.download.SoundDownloadSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.api.util.M3uParser;
import gg.moonflower.etched.api.util.ProgressTrackingInputStream;
import gg.moonflower.etched.common.sound.download.SoundCloudIdTracker;
import gg.moonflower.etched.common.sound.download.SourceRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SoundCloudSource
implements SoundDownloadSource {
    static final Logger LOGGER = LogManager.getLogger();
    private static final Component BRAND = Component.translatable((String)"sound_source.etched.sound_cloud").withStyle(style -> style.withColor(TextColor.fromRgb((int)0xFF5500)));
    private final Map<String, Boolean> validCache = new WeakHashMap<String, Boolean>();

    private static URL appendUri(String uri, String appendQuery) throws Exception {
        URI oldUri = new URI(uri);
        return new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), (String)(oldUri.getQuery() == null ? appendQuery : oldUri.getQuery() + "&" + appendQuery), oldUri.getFragment()).toURL();
    }

    private InputStream get(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy, int attempt, boolean requiresId) throws IOException {
        if (progressListener != null) {
            progressListener.progressStartRequest((Component)Component.translatable((String)"sound_source.etched.requesting", (Object[])new Object[]{this.getApiName()}));
        }
        try {
            URL uRL = requiresId ? SoundCloudSource.appendUri(url, "client_id=" + SoundCloudIdTracker.fetch(proxy)) : new URI(url).toURL();
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            httpURLConnection.setInstanceFollowRedirects(true);
            Map<String, String> map = SoundDownloadSource.getDownloadHeaders();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            int response = httpURLConnection.getResponseCode();
            if (requiresId && attempt == 0 && (response == 401 || response == 403)) {
                LOGGER.info("Attempting to authenticate");
                SoundCloudIdTracker.invalidate();
                return this.get(url, progressListener, proxy, 1, true);
            }
            long size = httpURLConnection.getContentLengthLong();
            if (response != 200) {
                throw new IOException(response + " " + httpURLConnection.getResponseMessage());
            }
            return size != -1L && progressListener != null ? new ProgressTrackingInputStream(httpURLConnection.getInputStream(), size, progressListener) : httpURLConnection.getInputStream();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    private <T> T resolve(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy, SourceRequest<T> function) throws IOException, URISyntaxException, JsonParseException {
        try (InputStreamReader reader = new InputStreamReader(this.get("https://api-v2.soundcloud.com/resolve?url=" + URLEncoder.encode(url, StandardCharsets.UTF_8), progressListener, proxy, 0, true));){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String kind = GsonHelper.getAsString((JsonObject)json, (String)"kind");
            if (!"track".equals(kind) && !"playlist".equals(kind)) {
                throw new IOException("URL is not a track or album");
            }
            if ("track".equals(kind) && !GsonHelper.getAsBoolean((JsonObject)json, (String)"streamable")) {
                throw new IOException("URL is not streamable");
            }
            if ("playlist".equals(kind) && !GsonHelper.getAsBoolean((JsonObject)json, (String)"is_album")) {
                throw new IOException("URL is not a track or album");
            }
            T t = function.process(json);
            return t;
        }
    }

    public List<URL> resolveUrl(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy) throws IOException, URISyntaxException, JsonParseException {
        return this.resolve(url, progressListener, proxy, json -> {
            if (progressListener != null) {
                progressListener.progressStartRequest(RESOLVING_TRACKS);
            }
            JsonArray media = GsonHelper.getAsJsonArray((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"media"), (String)"transcodings");
            EnumMap<Format, String> urls = new EnumMap<Format, String>(Format.class);
            for (int i = 0; i < media.size(); ++i) {
                JsonObject transcodingJson = GsonHelper.convertToJsonObject((JsonElement)media.get(i), (String)("transcodings[" + i + "]"));
                Format format = Format.parse(transcodingJson.getAsJsonObject("format"));
                if (format == null) continue;
                urls.put(format, GsonHelper.getAsString((JsonObject)transcodingJson, (String)"url"));
            }
            for (Format format : Format.FORMATS) {
                String dataUrl = (String)urls.get((Object)format);
                if (dataUrl == null) continue;
                try (InputStreamReader reader = new InputStreamReader(this.get(dataUrl, null, proxy, 0, true));){
                    JsonObject urlJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    if (format.isHls()) {
                        try (InputStream stream = this.get(GsonHelper.getAsString((JsonObject)urlJson, (String)"url"), null, proxy, 0, false);){
                            List<URL> list = M3uParser.parse(stream);
                            return list;
                        }
                    }
                    List<URL> list = Collections.singletonList(new URI(GsonHelper.getAsString((JsonObject)urlJson, (String)"url")).toURL());
                    return list;
                }
            }
            throw new IOException("Could not find an audio source");
        });
    }

    public List<TrackData> resolveTracks(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy) throws IOException, URISyntaxException, JsonParseException {
        return this.resolve(url, progressListener, proxy, json -> {
            JsonObject user = GsonHelper.getAsJsonObject((JsonObject)json, (String)"user");
            String artist = GsonHelper.getAsString((JsonObject)user, (String)"username");
            String title = GsonHelper.getAsString((JsonObject)json, (String)"title");
            String kind = GsonHelper.getAsString((JsonObject)json, (String)"kind");
            if ("playlist".equals(kind)) {
                JsonArray tracksJson = GsonHelper.getAsJsonArray((JsonObject)json, (String)"tracks");
                ArrayList<TrackData> tracks = new ArrayList<TrackData>();
                tracks.add(new TrackData(url, artist, (Component)Component.literal((String)title)));
                for (int i = 0; i < tracksJson.size(); ++i) {
                    try {
                        JsonObject trackJson = GsonHelper.convertToJsonObject((JsonElement)tracksJson.get(i), (String)("tracks[" + i + "]"));
                        if (!trackJson.has("permalink_url")) continue;
                        JsonObject trackUser = GsonHelper.getAsJsonObject((JsonObject)trackJson, (String)"user", (JsonObject)user);
                        String trackUrl = GsonHelper.getAsString((JsonObject)trackJson, (String)"permalink_url");
                        String trackArtist = GsonHelper.getAsString((JsonObject)trackUser, (String)"username");
                        String trackTitle = GsonHelper.getAsString((JsonObject)trackJson, (String)"title");
                        tracks.add(new TrackData(trackUrl, trackArtist, (Component)Component.literal((String)trackTitle)));
                        continue;
                    }
                    catch (JsonParseException e) {
                        LOGGER.error("Failed to parse track: {}[{}]", (Object)url, (Object)i, (Object)e);
                    }
                }
                return tracks;
            }
            return Collections.singletonList(new TrackData(url, artist, (Component)Component.literal((String)title)));
        });
    }

    @Override
    public Optional<String> resolveAlbumCover(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy, ResourceManager resourceManager) throws IOException, URISyntaxException, JsonParseException {
        return this.resolve(url, progressListener, proxy, json -> {
            if (!json.has("artwork_url") || json.get("artwork_url").isJsonNull()) {
                return Optional.empty();
            }
            return Optional.of(GsonHelper.getAsString((JsonObject)json, (String)"artwork_url"));
        });
    }

    @Override
    public boolean isValidUrl(String url) {
        return this.validCache.computeIfAbsent(url, key -> {
            try {
                String host = new URI((String)key).getHost();
                return host != null && host.endsWith("soundcloud.com");
            }
            catch (URISyntaxException e) {
                return false;
            }
        });
    }

    @Override
    public boolean isTemporary(String url) {
        return true;
    }

    @Override
    public String getApiName() {
        return "SoundCloud";
    }

    @Override
    public Optional<Component> getBrandText(String url) {
        return Optional.of(BRAND);
    }

    public static enum Format {
        OGG_PROGRESSIVE,
        MP3_PROGRESSIVE,
        OGG_HLS,
        MP3_HLS;

        private static final Format[] FORMATS;

        public boolean isHls() {
            return this == OGG_HLS || this == MP3_HLS;
        }

        @Nullable
        public static Format parse(JsonObject format) {
            String protocolString;
            JsonElement type = format.get("mime_type");
            if (type == null || !type.isJsonPrimitive()) {
                return null;
            }
            String typeString = type.getAsString().toLowerCase(Locale.ROOT);
            if (typeString.startsWith("audio/ogg")) {
                return null;
            }
            if (!typeString.startsWith("audio/mpeg")) {
                return null;
            }
            boolean mp3 = true;
            JsonElement protocol = format.get("protocol");
            if (protocol == null || !protocol.isJsonPrimitive()) {
                return null;
            }
            return switch (protocolString = protocol.getAsString().toLowerCase(Locale.ROOT)) {
                case "hls" -> {
                    if (mp3) {
                        yield MP3_HLS;
                    }
                    yield OGG_HLS;
                }
                case "progressive" -> {
                    if (mp3) {
                        yield MP3_PROGRESSIVE;
                    }
                    yield OGG_PROGRESSIVE;
                }
                default -> null;
            };
        }

        static {
            FORMATS = Format.values();
        }
    }
}

