/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.menu;

import gg.moonflower.etched.common.item.BoomboxItem;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BoomboxContainer
implements Container {
    private final Inventory inventory;
    private final int index;
    private final ItemStack boombox;
    private final NonNullList<ItemStack> keys;

    public BoomboxContainer(Inventory inventory, int index) {
        this.inventory = inventory;
        this.index = index;
        this.boombox = inventory.getItem(index);
        this.keys = NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{BoomboxItem.getRecord(this.boombox)});
    }

    private void update() {
        BoomboxItem.setRecord(this.boombox, (ItemStack)this.keys.getFirst());
    }

    public int getContainerSize() {
        return this.keys.size();
    }

    public boolean isEmpty() {
        return this.keys.isEmpty() || this.keys.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int index) {
        if (index < 0 || index >= this.keys.size()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.keys.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack result = ContainerHelper.removeItem(this.keys, (int)index, (int)count);
        this.update();
        return result;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack result = ContainerHelper.takeItem(this.keys, (int)index);
        this.update();
        return result;
    }

    public void setItem(int index, ItemStack stack) {
        if (index < 0 || index >= this.keys.size()) {
            return;
        }
        this.keys.set(index, (Object)stack);
        this.update();
    }

    public void setChanged() {
        this.update();
    }

    public boolean stillValid(Player player) {
        return ItemStack.matches((ItemStack)this.inventory.getItem(this.index), (ItemStack)this.boombox);
    }

    public void clearContent() {
        this.keys.clear();
        this.update();
    }
}

