/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.common.network.play.SetAlbumJukeboxTrackPacket;
import gg.moonflower.etched.core.Etched;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class AlbumJukeboxScreen
extends AbstractContainerScreen<AlbumJukeboxMenu> {
    private static final ResourceLocation CONTAINER_LOCATION = Etched.etchedPath("textures/gui/container/album_jukebox.png");
    private static final Component NOW_PLAYING = Component.translatable((String)"screen.etched.album_jukebox.now_playing").withStyle(ChatFormatting.YELLOW);
    private static final Component PREVIOUS = Component.translatable((String)"screen.etched.album_jukebox.previous");
    private static final Component NEXT = Component.translatable((String)"screen.etched.album_jukebox.next");
    private int playingIndex;
    private int playingTrack;

    public AlbumJukeboxScreen(AlbumJukeboxMenu dispenserMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)dispenserMenu, inventory, component);
    }

    private void update(boolean next) {
        AlbumJukeboxBlockEntity jukebox;
        ClientLevel level = this.minecraft.level;
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(((AlbumJukeboxMenu)this.menu).getPos());
        if (!(blockEntity instanceof AlbumJukeboxBlockEntity) || !(jukebox = (AlbumJukeboxBlockEntity)blockEntity).isPlaying()) {
            return;
        }
        int oldIndex = jukebox.getPlayingIndex();
        int oldTrack = jukebox.getTrack();
        if (next) {
            jukebox.next();
        } else {
            jukebox.previous();
        }
        if ((jukebox.getPlayingIndex() == oldIndex && jukebox.getTrack() != oldTrack || jukebox.recalculatePlayingIndex(!next)) && jukebox.getPlayingIndex() != -1) {
            SoundTracker.playAlbum(jukebox, jukebox.getBlockState(), (CommonLevelAccessor)level, ((AlbumJukeboxMenu)this.menu).getPos(), true);
            PacketDistributor.sendToServer((CustomPacketPayload)new SetAlbumJukeboxTrackPacket(jukebox.getPlayingIndex(), jukebox.getTrack()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void init() {
        super.init();
        int buttonPadding = 6;
        Font font = Minecraft.getInstance().font;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)PREVIOUS, b -> this.update(false)).bounds(this.leftPos + 3 + (58 - font.width((FormattedText)PREVIOUS)) / 2 - buttonPadding, this.topPos + 33, font.width((FormattedText)PREVIOUS) + 2 * buttonPadding, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)NEXT, b -> this.update(true)).bounds(this.leftPos + 115 + (58 - font.width((FormattedText)NEXT)) / 2 - buttonPadding, this.topPos + 33, font.width((FormattedText)NEXT) + 2 * buttonPadding, 20).build());
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiLeft = (this.width - this.imageWidth) / 2;
        int guiTop = (this.height - this.imageHeight) / 2;
        graphics.blit(CONTAINER_LOCATION, guiLeft, guiTop, 0, 0, this.imageWidth, this.imageHeight);
        this.playingIndex = -1;
        this.playingTrack = 0;
        ClientLevel level = this.minecraft.level;
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(((AlbumJukeboxMenu)this.menu).getPos());
        if (!(blockEntity instanceof AlbumJukeboxBlockEntity)) {
            return;
        }
        AlbumJukeboxBlockEntity jukebox = (AlbumJukeboxBlockEntity)blockEntity;
        this.playingIndex = jukebox.getPlayingIndex();
        this.playingTrack = jukebox.getTrack();
        if (this.playingIndex != -1) {
            int x = this.playingIndex % 3;
            int y = this.playingIndex / 3;
            graphics.fill(guiLeft + 62 + x * 18, guiTop + 17 + y * 18, guiLeft + 78 + x * 18, guiTop + 33 + y * 18, 1022820096);
        }
    }

    protected List<Component> getTooltipFromContainerItem(ItemStack stack) {
        List tooltip = super.getTooltipFromContainerItem(stack);
        if (this.hoveredSlot != null && this.hoveredSlot.index == this.playingIndex) {
            List<TrackData> tracks;
            if (this.playingTrack >= 0 && this.playingTrack < (tracks = PlayableRecord.getTracks((HolderLookup.Provider)this.minecraft.getConnection().registryAccess(), stack)).size()) {
                TrackData track = tracks.get(this.playingTrack);
                tooltip.add(NOW_PLAYING.copy().append(": ").append(track.getDisplayName()).append(" (" + (this.playingTrack + 1) + "/" + tracks.size() + ")"));
                return tooltip;
            }
            tooltip.add(NOW_PLAYING);
        }
        return tooltip;
    }
}

