/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import org.jetbrains.annotations.NotNull;

public class Mp3InputStream
extends InputStream {
    private final Bitstream stream;
    private final Decoder decoder;
    private final ByteBuffer buffer;
    private AudioFormat format;

    public Mp3InputStream(InputStream source) throws IOException {
        this.stream = new Bitstream(source);
        this.decoder = new Decoder();
        this.buffer = ByteBuffer.allocate(4608).order(ByteOrder.LITTLE_ENDIAN);
        if (this.fillBuffer()) {
            throw new IOException("Failed to find header");
        }
    }

    private boolean fillBuffer() throws IOException {
        this.buffer.clear();
        try {
            Header header = this.stream.readFrame();
            if (header == null) {
                this.buffer.flip();
                boolean bl = true;
                return bl;
            }
            if (this.format == null) {
                int channels = header.mode() == 3 ? 1 : 2;
                this.format = new AudioFormat(header.frequency(), 16, channels, true, false);
            }
            SampleBuffer decoderOutput = (SampleBuffer)this.decoder.decodeFrame(header, this.stream);
            short[] data = decoderOutput.getBuffer();
            this.buffer.asShortBuffer().put(data);
            this.buffer.position(data.length * 2);
            this.buffer.flip();
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        finally {
            this.stream.closeFrame();
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining() && this.fillBuffer()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        int read;
        int readLength;
        for (read = 0; read < len; read += readLength) {
            if (!this.buffer.hasRemaining() && this.fillBuffer()) {
                return read > 0 ? read : -1;
            }
            readLength = Math.min(this.buffer.remaining(), len - read);
            this.buffer.get(b, off + read, readLength);
        }
        return read;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream.close();
        }
        catch (JavaLayerException e) {
            throw new IOException(e);
        }
    }

    public AudioFormat getFormat() {
        return this.format;
    }
}

