/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound;

import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.SoundStreamModifier;
import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.sound.stream.MonoWrapper;
import gg.moonflower.etched.api.sound.stream.RawAudioStream;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.api.util.Mp3InputStream;
import gg.moonflower.etched.api.util.WaveDataReader;
import gg.moonflower.etched.client.sound.EmptyAudioStream;
import gg.moonflower.etched.client.sound.SoundCache;
import gg.moonflower.etched.core.Etched;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.JOrbisAudioStream;
import net.minecraft.client.sounds.LoopingAudioStream;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.client.sounds.Weighted;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.SampledFloat;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class AbstractOnlineSoundInstance
extends AbstractSoundInstance {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String url;
    private final String subtitle;
    private final int attenuationDistance;
    private final DownloadProgressListener progressListener;
    private final AudioSource.AudioFileType type;
    private final boolean stereo;

    public AbstractOnlineSoundInstance(String url, @Nullable String subtitle, int attenuationDistance, SoundSource source, DownloadProgressListener progressListener, AudioSource.AudioFileType type, boolean stereo) {
        super(Etched.etchedPath(DigestUtils.sha1Hex((String)url)), source, SoundInstance.createUnseededRandom());
        this.url = url;
        this.subtitle = subtitle;
        this.attenuationDistance = attenuationDistance;
        this.progressListener = progressListener;
        this.type = type;
        this.stereo = (Boolean)Etched.CLIENT_CONFIG.forceStereo.get() != false || stereo;
    }

    private static AudioStream getStream(AudioStream stream, Sound sound) {
        return sound instanceof SoundStreamModifier ? ((SoundStreamModifier)sound).modifyStream(stream) : new MonoWrapper(stream);
    }

    public WeighedSoundEvents resolve(SoundManager soundManager) {
        WeighedSoundEvents weighedSoundEvents = new WeighedSoundEvents(this.getLocation(), this.subtitle);
        weighedSoundEvents.addSound((Weighted)new OnlineSound(this.getLocation(), this.url, this.attenuationDistance, this.progressListener, this.type, this.stereo));
        this.sound = weighedSoundEvents.getSound(this.random);
        return weighedSoundEvents;
    }

    public AbstractOnlineSoundInstance setLoop(boolean loop) {
        this.looping = loop;
        return this;
    }

    public CompletableFuture<AudioStream> getStream(SoundBufferLibrary loader, Sound sound, boolean repeatInstantly) {
        ResourceLocation name;
        if (!(sound instanceof OnlineSound)) {
            return super.getStream(loader, sound, repeatInstantly);
        }
        OnlineSound onlineSound = (OnlineSound)sound;
        if (TrackData.isLocalSound(onlineSound.getURL()) && (name = ResourceLocation.tryParse((String)onlineSound.getURL())) != null) {
            WeighedSoundEvents weighedSoundEvents = Minecraft.getInstance().getSoundManager().getSoundEvent(name);
            if (weighedSoundEvents == null) {
                return CompletableFuture.failedFuture(new FileNotFoundException("Unable to play unknown soundEvent: " + String.valueOf(sound.getPath())));
            }
            return ((CompletableFuture)loader.getStream(weighedSoundEvents.getSound(this.random).getPath(), repeatInstantly).thenApply(MonoWrapper::new)).handleAsync((stream, throwable) -> {
                if (throwable != null) {
                    LOGGER.error("Failed to load audio from client: {}", (Object)onlineSound.getURL(), throwable);
                    onlineSound.getProgressListener().onFail();
                    return EmptyAudioStream.INSTANCE;
                }
                onlineSound.getProgressListener().onSuccess();
                return stream;
            }, (Executor)Util.nonCriticalIoPool());
        }
        return ((CompletableFuture)((CompletableFuture)SoundCache.getAudioStream(onlineSound.getURL(), onlineSound.getProgressListener(), onlineSound.getAudioFileType()).thenCompose(AudioSource::openStream)).thenApplyAsync(stream -> {
            onlineSound.getProgressListener().progressStartLoading();
            try {
                BufferedInputStream is = new BufferedInputStream((InputStream)stream);
                assert (((InputStream)is).markSupported());
                ((InputStream)is).mark(8192);
                try {
                    return AbstractOnlineSoundInstance.getStream((AudioStream)(repeatInstantly ? new LoopingAudioStream(JOrbisAudioStream::new, (InputStream)is) : new JOrbisAudioStream((InputStream)is)), sound);
                }
                catch (Exception e) {
                    ((InputStream)is).reset();
                    try {
                        AudioInputStream ais = WaveDataReader.getAudioInputStream(is);
                        AudioFormat format = ais.getFormat();
                        return AbstractOnlineSoundInstance.getStream((AudioStream)(repeatInstantly ? new LoopingAudioStream(input -> new RawAudioStream(format, input), (InputStream)ais) : new RawAudioStream(format, ais)), sound);
                    }
                    catch (Exception e1) {
                        ((InputStream)is).reset();
                        try {
                            Mp3InputStream mp3InputStream = new Mp3InputStream(is);
                            return AbstractOnlineSoundInstance.getStream((AudioStream)(repeatInstantly ? new LoopingAudioStream(input -> new RawAudioStream(mp3InputStream.getFormat(), input), (InputStream)mp3InputStream) : new RawAudioStream(mp3InputStream.getFormat(), mp3InputStream)), sound);
                        }
                        catch (Exception e2) {
                            UnsupportedAudioFileException cause = new UnsupportedAudioFileException("Could not load as OGG, WAV, OR MP3");
                            try {
                                ((InputStream)is).close();
                            }
                            catch (Exception e3) {
                                cause.addSuppressed(e3);
                            }
                            cause.addSuppressed(e);
                            cause.addSuppressed(e1);
                            cause.addSuppressed(e2);
                            throw new CompletionException(cause);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, (Executor)Util.nonCriticalIoPool())).handleAsync((stream, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    CompletionException e = (CompletionException)throwable;
                    throwable = e.getCause();
                }
                LOGGER.error("Failed to load audio from url: {}", (Object)onlineSound.getURL(), throwable);
                onlineSound.getProgressListener().onFail();
                return EmptyAudioStream.INSTANCE;
            }
            onlineSound.getProgressListener().onSuccess();
            return stream;
        }, (Executor)Util.nonCriticalIoPool());
    }

    public static class OnlineSound
    extends Sound
    implements SoundStreamModifier {
        private final String url;
        private final DownloadProgressListener progressListener;
        private final AudioSource.AudioFileType type;
        private final boolean stereo;

        public OnlineSound(ResourceLocation location, String url, int attenuationDistance, DownloadProgressListener progressListener, AudioSource.AudioFileType type, boolean stereo) {
            super(location, (SampledFloat)ConstantFloat.of((float)1.0f), (SampledFloat)ConstantFloat.of((float)1.0f), 1, Sound.Type.FILE, true, false, attenuationDistance);
            this.url = url;
            this.progressListener = progressListener;
            this.type = type;
            this.stereo = stereo;
        }

        public String getURL() {
            return this.url;
        }

        public DownloadProgressListener getProgressListener() {
            return this.progressListener;
        }

        public AudioSource.AudioFileType getAudioFileType() {
            return this.type;
        }

        @Override
        public AudioStream modifyStream(AudioStream stream) {
            return this.stereo ? stream : new MonoWrapper(stream);
        }
    }
}

