/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.client.widget;

import com.epherical.shoppy.block.entity.BarteringBlockEntity;
import java.util.List;
import java.util.Optional;
import java.util.function.IntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class RowButton
extends AbstractWidget {
    private static final int ITEM_SIZE = 16;
    private static final int TEXT_Y_OFF = 6;
    private static final int ROW_PAD_X = 8;
    private static final int CONFIRM_W = 52;
    private static final int CONFIRM_H = 16;
    private final BarteringBlockEntity bartering;
    private final int offerIndex;
    private final IntConsumer confirmAction;
    private boolean awaitingConfirm = false;

    public RowButton(int x, int y, int width, int height, int offerIndex, BarteringBlockEntity bartering, IntConsumer confirmAction) {
        super(x, y, width, height, (Component)Component.empty());
        this.offerIndex = offerIndex;
        this.bartering = bartering;
        this.confirmAction = confirmAction;
    }

    protected void renderWidget(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        boolean hovering = this.isMouseOver(mouseX, mouseY);
        int colour = hovering || this.awaitingConfirm ? -1426063361 : -2013265920;
        g.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, colour);
        this.renderOffer(g, mouseX, mouseY);
        if (this.awaitingConfirm) {
            g.pose().pushPose();
            g.pose().translate(0.0f, 0.0f, 1000.0f);
            this.renderConfirmButton(g, mouseX, mouseY);
            g.pose().translate(0.0f, 0.0f, -1000.0f);
            g.pose().popPose();
        }
    }

    private void renderOffer(GuiGraphics g, int mouseX, int mouseY) {
        ItemStack saleItem = this.bartering.getSaleItem();
        int saleCnt = this.bartering.getSaleCount(this.offerIndex);
        if (!saleItem.isEmpty()) {
            g.renderItem(saleItem, this.getX() + 8, this.getY() + 1);
            g.drawString(Minecraft.getInstance().font, String.valueOf(saleCnt), this.getX() + 8 + 16 + 4, this.getY() + 6, 0xFFFFFF, false);
            if (RowButton.isHovering(mouseX, mouseY, this.getX() + 8, this.getY() + 1)) {
                RowButton.showTooltip(g, mouseX, mouseY, saleItem, (Component)Component.translatable((String)"tooltip.shoppy.sale_item"));
            }
        }
        ItemStack curItem = this.bartering.getCurrencyItem();
        int costCnt = this.bartering.getCostCount(this.offerIndex);
        if (!curItem.isEmpty()) {
            int curX = this.getX() + this.width - 16 - 40;
            g.renderItem(curItem, curX, this.getY() + 1);
            g.drawString(Minecraft.getInstance().font, String.valueOf(costCnt), curX + 16 + 4, this.getY() + 6, 0xFFFFFF, false);
            if (RowButton.isHovering(mouseX, mouseY, curX, this.getY() + 1)) {
                RowButton.showTooltip(g, mouseX, mouseY, curItem, (Component)Component.translatable((String)"tooltip.shoppy.currency_item"));
            }
        }
    }

    private void renderConfirmButton(GuiGraphics g, int mouseX, int mouseY) {
        int btnX = this.getX() + this.width - 52 - 8;
        int btnY = this.getY() + (this.height - 16) / 2;
        boolean hover = mouseX >= btnX && mouseX < btnX + 52 && mouseY >= btnY && mouseY < btnY + 16;
        int bg = hover ? -11751600 : -13070788;
        g.fill(btnX, btnY, btnX + 52, btnY + 16, bg);
        MutableComponent txt = Component.translatable((String)"screen.shoppy.confirm");
        int txtW = Minecraft.getInstance().font.width((FormattedText)txt);
        g.drawString(Minecraft.getInstance().font, (Component)txt, btnX + (52 - txtW) / 2, btnY + 4, 0xFFFFFF, false);
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.awaitingConfirm) {
            if (this.insideConfirm(mouseX, mouseY)) {
                this.confirmAction.accept(this.offerIndex);
                this.awaitingConfirm = false;
            }
        } else {
            this.awaitingConfirm = true;
        }
    }

    private boolean insideConfirm(double mouseX, double mouseY) {
        int btnX = this.getX() + this.width - 52 - 8;
        int btnY = this.getY() + (this.height - 16) / 2;
        return mouseX >= (double)btnX && mouseX < (double)(btnX + 52) && mouseY >= (double)btnY && mouseY < (double)(btnY + 16);
    }

    private static boolean isHovering(int mouseX, int mouseY, int x, int y) {
        return mouseX >= x && mouseX < x + 16 && mouseY >= y && mouseY < y + 16;
    }

    private static void showTooltip(GuiGraphics g, int mouseX, int mouseY, ItemStack stack, Component extraLine) {
        Minecraft mc = Minecraft.getInstance();
        List lines = stack.getTooltipLines(Item.TooltipContext.of((Level)mc.player.level()), (Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        lines.add(extraLine);
        g.renderTooltip(mc.font, lines, Optional.empty(), mouseX, mouseY);
    }

    protected void updateWidgetNarration(NarrationElementOutput narration) {
    }
}

