/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.client.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AddItemButton
extends Button {
    protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"shoppy", (String)"widget/add_item"), ResourceLocation.fromNamespaceAndPath((String)"shoppy", (String)"widget/add_item"), ResourceLocation.fromNamespaceAndPath((String)"shoppy", (String)"widget/add_item_hovered"));

    protected AddItemButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, Button.CreateNarration createNarration) {
        super(x, y, width, height, message, onPress, createNarration);
    }

    protected AddItemButton(Builder builder) {
        this(builder.x, builder.y, builder.width, builder.height, builder.message, builder.onPress, builder.createNarration);
        this.setTooltip(builder.tooltip);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.getFGColor();
        this.renderString(guiGraphics, minecraft.font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int width, int color) {
        int minx = this.getX() + width + 12;
        int maxy = this.getX() + this.getWidth() - width;
        AddItemButton.renderScrollingString((GuiGraphics)guiGraphics, (Font)font, (Component)this.getMessage(), (int)minx, (int)this.getY(), (int)maxy, (int)(this.getY() + this.getHeight()), (int)color);
    }

    public static Builder addItem(Component message, Button.OnPress onPress) {
        return new Builder(message, onPress);
    }

    static /* synthetic */ Button.CreateNarration access$000() {
        return DEFAULT_NARRATION;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final Component message;
        private final Button.OnPress onPress;
        @Nullable
        private Tooltip tooltip;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private Button.CreateNarration createNarration = AddItemButton.access$000();

        public Builder(Component message, Button.OnPress onPress) {
            this.message = message;
            this.onPress = onPress;
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder bounds(int x, int y, int width, int height) {
            return this.pos(x, y).size(width, height);
        }

        public Builder tooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder createNarration(Button.CreateNarration createNarration) {
            this.createNarration = createNarration;
            return this;
        }

        public AddItemButton build() {
            return this.build(AddItemButton::new);
        }

        public AddItemButton build(Function<Builder, AddItemButton> builder) {
            return builder.apply(this);
        }
    }
}

