/*
 * Decompiled with CFR 0.152.
 */
package net.akaciobahno.backported_animal_variants.event;

import net.akaciobahno.backported_animal_variants.entity.ModEntities;
import net.akaciobahno.backported_animal_variants.entity.ModModelLayers;
import net.akaciobahno.backported_animal_variants.entity.client.CustomCowModel;
import net.akaciobahno.backported_animal_variants.entity.client.CustomCowRenderer;
import net.akaciobahno.backported_animal_variants.entity.client.CustomMooshroomRenderer;
import net.akaciobahno.backported_animal_variants.entity.client.CustomSheepFurModel;
import net.akaciobahno.backported_animal_variants.entity.client.CustomSheepModel;
import net.akaciobahno.backported_animal_variants.entity.client.CustomSheepRenderer;
import net.akaciobahno.backported_animal_variants.entity.client.CustomSheepSkinModel;
import net.akaciobahno.backported_animal_variants.entity.custom.ColdChicken;
import net.akaciobahno.backported_animal_variants.entity.custom.ColdCow;
import net.akaciobahno.backported_animal_variants.entity.custom.ColdPig;
import net.akaciobahno.backported_animal_variants.entity.custom.ThrownBlueEgg;
import net.akaciobahno.backported_animal_variants.entity.custom.ThrownBrownEgg;
import net.akaciobahno.backported_animal_variants.entity.custom.WarmChicken;
import net.akaciobahno.backported_animal_variants.entity.custom.WarmCow;
import net.akaciobahno.backported_animal_variants.entity.custom.WarmPig;
import net.akaciobahno.backported_animal_variants.item.ModItems;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;

@EventBusSubscriber(modid="backported_animal_variants", bus=EventBusSubscriber.Bus.MOD)
public class ModEventBusEvents {
    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(ModEntities.COLD_PIG.get(), ColdPig.createAtrributes().build());
        event.put(ModEntities.WARM_PIG.get(), WarmPig.createAtrributes().build());
        event.put(ModEntities.COLD_COW.get(), ColdCow.createAtrributes().build());
        event.put(ModEntities.WARM_COW.get(), WarmCow.createAtrributes().build());
        event.put(ModEntities.COLD_CHICKEN.get(), ColdChicken.createAtrributes().build());
        event.put(ModEntities.WARM_CHICKEN.get(), WarmChicken.createAtrributes().build());
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.BLUE_EGG.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

                protected ItemStack execute(BlockSource source, ItemStack stack) {
                    ServerLevel level = source.level();
                    Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                    Position spawnPos = DispenserBlock.getDispensePosition((BlockSource)source);
                    ThrownBlueEgg blueEgg = new ThrownBlueEgg((Level)level, spawnPos.x(), spawnPos.y(), spawnPos.z());
                    blueEgg.shoot(direction.getStepX(), (float)direction.getStepY() + 0.1f, direction.getStepZ(), 1.1f, 6.0f);
                    level.addFreshEntity((Entity)blueEgg);
                    stack.shrink(1);
                    return stack;
                }

                protected void playSound(BlockSource source) {
                    source.level().levelEvent(1002, source.pos(), 0);
                }
            });
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.BROWN_EGG.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

                protected ItemStack execute(BlockSource source, ItemStack stack) {
                    ServerLevel level = source.level();
                    Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                    Position spawnPos = DispenserBlock.getDispensePosition((BlockSource)source);
                    ThrownBrownEgg brownEgg = new ThrownBrownEgg((Level)level, spawnPos.x(), spawnPos.y(), spawnPos.z());
                    brownEgg.shoot(direction.getStepX(), (float)direction.getStepY() + 0.1f, direction.getStepZ(), 1.1f, 6.0f);
                    level.addFreshEntity((Entity)brownEgg);
                    stack.shrink(1);
                    return stack;
                }

                protected void playSound(BlockSource source) {
                    source.level().levelEvent(1002, source.pos(), 0);
                }
            });
        });
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModModelLayers.CUSTOM_COW_LAYER, CustomCowModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.CUSTOM_MOOSHROOM_LAYER, CustomCowModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.CUSTOM_SHEEP_LAYER, CustomSheepModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.CUSTOM_SHEEP_FUR_LAYER, CustomSheepFurModel::createFurLayer);
        event.registerLayerDefinition(ModModelLayers.CUSTOM_SHEEP_SKIN_LAYER, CustomSheepSkinModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        EntityRenderers.register((EntityType)EntityType.COW, CustomCowRenderer::new);
        EntityRenderers.register((EntityType)EntityType.MOOSHROOM, CustomMooshroomRenderer::new);
        EntityRenderers.register((EntityType)EntityType.SHEEP, CustomSheepRenderer::new);
    }
}

